# 帳票設計書 62-StorageVersionMigration一覧

## 概要

本ドキュメントは、KubernetesのStorageVersionMigrationリソースをテーブル形式で一覧出力する帳票の設計書である。`kubectl get storageversionmigrations` コマンド実行時に、ストレージバージョンマイグレーションの状態を一覧表示する。

### 本帳票の処理概要

**業務上の目的・背景**：Kubernetesクラスタでは、APIリソースのストレージバージョンが変更された際に、既存のデータを新しいバージョンに移行する必要がある。StorageVersionMigrationリソースはこの移行処理の進捗を追跡するオブジェクトであり、クラスタ管理者がマイグレーションの状況を把握し、問題の早期発見と対処を行うために本帳票が必要である。

**帳票の利用シーン**：クラスタのバージョンアップグレード後にストレージマイグレーションの進捗を確認する場合、マイグレーション失敗の原因調査を行う場合、全リソースのマイグレーション完了を確認する場合に利用される。

**主要な出力内容**：
1. Name - マイグレーションリソースの名前
2. Resource - マイグレーション対象のGroupResource
3. Status - マイグレーションの現在のステータス（Running/Failed/Succeeded/Unknown）

**帳票の出力タイミング**：`kubectl get storageversionmigrations` コマンドの実行時にAPIサーバからリソース情報を取得し、即座にテーブル形式で標準出力に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア。

## 帳票種別

一覧表（リソーステーブル出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（ターミナル） | - | `kubectl get storageversionmigrations` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

タブ区切りのテーブル形式で出力される。1行目がヘッダー行、2行目以降がデータ行となる。

```
┌──────────────────────────────────────────────────────┐
│  NAME                    RESOURCE           STATUS    │
├──────────────────────────────────────────────────────┤
│  migrate-configmaps      configmaps         Succeeded │
│  migrate-secrets         secrets            Running   │
└──────────────────────────────────────────────────────┘
```

### ヘッダー部

該当なし（テーブルヘッダー行として出力）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | NAME | マイグレーションリソース名 | obj.Name | 文字列 | 自動調整 |
| 2 | RESOURCE | マイグレーション対象GroupResource | obj.Spec.Resource.String() | 文字列 | 自動調整 |
| 3 | STATUS | マイグレーション状態 | obj.Status.Conditions（ConditionTrue判定） | Running/Failed/Succeeded/Unknown | 自動調整 |

### フッター部

該当なし

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| LabelSelector | ラベルによるフィルタリング（`-l`オプション） | No |
| FieldSelector | フィールドによるフィルタリング（`--field-selector`オプション） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバのデフォルト） |

### 改ページ条件

改ページなし（全件を連続出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/storageversionmigrations/ | StorageVersionMigrationリソースの永続化ストア | APIサーバ経由でRESTアクセス |

### テーブル別参照項目詳細

#### StorageVersionMigration (storagemigration.k8s.io/v1alpha1)

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | LIST APIで一括取得 | - |
| spec.resource | RESOURCE | 同上 | String()メソッドでGroupResource文字列化 |
| status.conditions | STATUS | 同上 | ConditionTrueのタイプを表示 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| STATUS | Conditionsを走査しConditionTrue状態のものを検索。MigrationRunning/MigrationFailed/MigrationSucceededのいずれかを表示 | N/A | 該当するConditionがない場合は"Unknown" |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get storageversionmigrations 実行] --> B[コマンド引数・フラグ解析]
    B --> C[APIサーバへStorageVersionMigration LIST リクエスト]
    C --> D[サーバサイドでテーブル変換]
    D --> E[metav1.Table形式でレスポンス]
    E --> F[HumanReadablePrinter.PrintObj]
    F --> G[テーブルヘッダー出力]
    G --> H[各行のセル値を出力]
    H --> I[標準出力に表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| APIサーバ接続エラー | クラスタに接続できない場合 | `The connection to the server ... was refused` | kubeconfig設定確認 |
| 権限エラー | StorageVersionMigrationリソースのlist権限がない場合 | `Error from server (Forbidden): ...` | RBAC設定確認 |
| リソースなし | StorageVersionMigrationリソースが存在しない場合 | `No resources found` | 正常動作（データなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件（マイグレーション対象リソース数に依存） |
| 目標出力時間 | APIサーバレスポンスに依存（通常1秒以内） |
| 同時出力数上限 | N/A（CLI単発実行） |

## セキュリティ考慮事項

StorageVersionMigrationリソースの閲覧にはRBACによるlist/get権限が必要である。マイグレーション情報からクラスタ内部のリソース構成が推測可能なため、アクセス制御に注意が必要。

## 備考

- StorageVersionMigrationはクラスタスコープのリソースである
- マイグレーション状態は3種類: MigrationRunning, MigrationFailed, MigrationSucceeded
- いずれのConditionもTrueでない場合は"Unknown"と表示される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

StorageVersionMigrationリソースのカラム定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | 732-738行目: storageVersionMigrationColumnDefinitionsでName, Resource, Statusの3カラムが定義されている |

**読解のコツ**: カラム定義のDescriptionフィールドは主にAPIドキュメント生成やサーバサイドのSwagger出力に利用される。

#### Step 2: エントリーポイントを理解する

printStorageVersionMigration関数でのテーブル行生成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3289-3322行目: printStorageVersionMigration関数とprintStorageVersionMigrationList関数 |

**主要処理フロー**:
1. **3293行目**: `obj.Spec.Resource.String()`でGroupResource文字列を取得
2. **3296-3305行目**: Status.Conditionsをループし、`ConditionTrue`かつMigrationRunning/Failed/Succeededのいずれかに該当するものを検索
3. **3306行目**: 見つかったステータスをセルに追加。見つからない場合は"Unknown"

#### Step 3: テーブル出力エンジンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | 95-167行目: HumanReadablePrinter.PrintObj |

### プログラム呼び出し階層図

```
kubectl get storageversionmigrations
    |
    +-- APIサーバ (LIST /apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations)
    |       |
    |       +-- TableConvertor (サーバサイドテーブル変換)
    |               |
    |               +-- printStorageVersionMigration() [printers.go:3289]
    |
    +-- HumanReadablePrinter.PrintObj() [tableprinter.go:95]
            |
            +-- decorateTable() [tableprinter.go:309]
            |
            +-- printTable() [tableprinter.go:172]
```

### データフロー図

```
[入力]                              [処理]                              [出力]

etcd StorageVersionMigration  -->  APIサーバ LIST                  -->  metav1.Table
リソース一覧                         (サーバサイドテーブル変換)

metav1.Table                  -->  HumanReadablePrinter.PrintObj  -->  標準出力
                                   (tabwriter整形)                     (テーブル形式テキスト)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | StorageVersionMigrationのカラム定義とテーブル行生成ロジック |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力エンジン |
| interface.go | `staging/src/k8s.io/cli-runtime/pkg/printers/interface.go` | ソース | ResourcePrinterインターフェース定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printStorageVersionMigration関数のテストケース |
