# 帳票設計書 63-Workload一覧

## 概要

本ドキュメントは、KubernetesのWorkloadリソースをテーブル形式で一覧出力する帳票の設計書である。`kubectl get workloads` コマンド実行時に、クラスタに登録されているWorkloadリソースの情報を一覧表示する。

### 本帳票の処理概要

**業務上の目的・背景**：Workloadリソースはスケジューリングに関連するリソースであり、ワークロードの管理・可視化を行うために本帳票が必要である。クラスタ管理者がワークロードの状態を素早く把握し、スケジューリングに関する問題の調査を行う際に活用される。

**帳票の利用シーン**：クラスタ内のワークロード一覧を確認する場合、ワークロードの作成日時を確認して古いワークロードを特定する場合、ワークロードのライフサイクル管理を行う場合に利用される。

**主要な出力内容**：
1. Name - ワークロードリソースの名前
2. Age - リソース作成からの経過時間

**帳票の出力タイミング**：`kubectl get workloads` コマンドの実行時にAPIサーバからリソース情報を取得し、即座にテーブル形式で標準出力に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア、アプリケーション開発者。

## 帳票種別

一覧表（リソーステーブル出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（ターミナル） | - | `kubectl get workloads` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

タブ区切りのテーブル形式で出力される。1行目がヘッダー行、2行目以降がデータ行となる。

```
┌──────────────────────────────────┐
│  NAME               AGE          │
├──────────────────────────────────┤
│  my-workload        5d           │
│  batch-job-1        2h           │
└──────────────────────────────────┘
```

### ヘッダー部

該当なし（テーブルヘッダー行として出力）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | NAME | ワークロードリソース名 | obj.Name | 文字列 | 自動調整 |
| 2 | AGE | リソース作成からの経過時間 | obj.CreationTimestamp | 人間可読な経過時間（例: 5d, 2h, 30m） | 自動調整 |

### フッター部

該当なし

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | ネームスペースによるフィルタリング（`-n`オプション） | No |
| LabelSelector | ラベルによるフィルタリング（`-l`オプション） | No |
| FieldSelector | フィールドによるフィルタリング（`--field-selector`オプション） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバのデフォルト） |

### 改ページ条件

改ページなし（全件を連続出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/workloads/ | Workloadリソースの永続化ストア | APIサーバ経由でRESTアクセス |

### テーブル別参照項目詳細

#### Workload (scheduling.k8s.io)

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | LIST APIで一括取得 | - |
| metadata.creationTimestamp | AGE | 同上 | translateTimestampSinceで経過時間に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| AGE | `time.Since(obj.CreationTimestamp.Time)` をHumanDurationで人間可読形式に変換 | N/A | duration.HumanDuration関数を使用。ゼロ値の場合は`<unknown>` |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get workloads 実行] --> B[コマンド引数・フラグ解析]
    B --> C[APIサーバへWorkload LIST リクエスト]
    C --> D[サーバサイドでテーブル変換]
    D --> E[metav1.Table形式でレスポンス]
    E --> F[HumanReadablePrinter.PrintObj]
    F --> G[テーブルヘッダー出力]
    G --> H[各行のセル値を出力]
    H --> I[標準出力に表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| APIサーバ接続エラー | クラスタに接続できない場合 | `The connection to the server ... was refused` | kubeconfig設定確認 |
| 権限エラー | Workloadリソースのlist権限がない場合 | `Error from server (Forbidden): ...` | RBAC設定確認 |
| リソースなし | Workloadリソースが存在しない場合 | `No resources found` | 正常動作（データなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数百件 |
| 目標出力時間 | APIサーバレスポンスに依存（通常1秒以内） |
| 同時出力数上限 | N/A（CLI単発実行） |

## セキュリティ考慮事項

Workloadリソースの閲覧にはRBACによるlist/get権限が必要である。

## 備考

- Workloadはscheduling APIグループに属するリソースである
- カラム定義のNameには`Format: "name"`が設定されており、`--sort-by`やリソース種別プレフィックス付与に対応
- `-o wide`オプションでは追加カラムは定義されていない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Workloadリソースのカラム定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | 740-745行目: workloadColumnDefinitionsでName(Format:"name"), Ageの2カラムが定義 |

**読解のコツ**: `Format: "name"`はNameカラムに設定される特殊フォーマットで、`--sort-by`オプションや`-o wide`での種別プレフィックス付与に使用される。

#### Step 2: エントリーポイントを理解する

printWorkload関数でのテーブル行生成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3324-3344行目: printWorkload関数とprintWorkloadList関数 |

**主要処理フロー**:
1. **3328行目**: `obj.Name`でリソース名を取得
2. **3329行目**: `translateTimestampSince(obj.CreationTimestamp)`でAge値を計算
3. **3329行目**: Name, Ageをセルに追加

#### Step 3: テーブル出力エンジンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | 95-167行目: HumanReadablePrinter.PrintObj |
| 3-2 | tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | 583-589行目: translateTimestampSince関数 |

### プログラム呼び出し階層図

```
kubectl get workloads
    |
    +-- APIサーバ (LIST /apis/scheduling.k8s.io/.../workloads)
    |       |
    |       +-- TableConvertor (サーバサイドテーブル変換)
    |               |
    |               +-- printWorkload() [printers.go:3324]
    |                       |
    |                       +-- translateTimestampSince() [tableprinter.go:583]
    |
    +-- HumanReadablePrinter.PrintObj() [tableprinter.go:95]
            |
            +-- decorateTable() [tableprinter.go:309]
            |
            +-- printTable() [tableprinter.go:172]
```

### データフロー図

```
[入力]                    [処理]                              [出力]

etcd Workload      -->  APIサーバ LIST                  -->  metav1.Table
リソース一覧              (サーバサイドテーブル変換)

metav1.Table       -->  HumanReadablePrinter.PrintObj  -->  標準出力
                        (tabwriter整形)                     (テーブル形式テキスト)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | Workloadのカラム定義とテーブル行生成ロジック |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力エンジン |
| interface.go | `staging/src/k8s.io/cli-runtime/pkg/printers/interface.go` | ソース | ResourcePrinterインターフェース定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printWorkload関数のテストケース |
