# 帳票設計書 69-クラスタ情報出力

## 概要

本ドキュメントは、Kubernetesクラスタの基本情報（コントロールプレーンのURLおよびクラスタサービスのURL）を出力する帳票の設計書である。`kubectl cluster-info` コマンド実行時に、APIサーバのURLとラベル`kubernetes.io/cluster-service=true`が付与されたServiceの情報を標準出力に表示する。

### 本帳票の処理概要

**業務上の目的・背景**：Kubernetesクラスタの基本的な接続情報を迅速に確認する必要がある。クラスタのコントロールプレーンのURLや、DNS、ダッシュボードなどのクラスタサービスのアクセスURLを一覧表示することで、クラスタへのアクセス方法やサービスの稼働状況を素早く把握できる。

**帳票の利用シーン**：クラスタの初期セットアップ後に接続情報を確認する場合、新しいチームメンバーにクラスタ情報を共有する場合、トラブルシューティングでコントロールプレーンの到達性を確認する場合に利用される。

**主要な出力内容**：
1. Kubernetesコントロールプレーンの実行URL
2. `kubernetes.io/cluster-service=true`ラベルが付いたServiceのURL一覧
3. cluster-info dumpへの案内メッセージ

**帳票の出力タイミング**：`kubectl cluster-info` コマンド実行時に即座に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、開発者、SRE。

## 帳票種別

診断レポート（クラスタ基本情報）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（ターミナル） | - | `kubectl cluster-info` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

各サービスのURL情報を1行ずつテキスト形式で出力する。末尾にcluster-info dumpの案内メッセージを表示する。

```
Kubernetes control plane is running at https://192.168.1.100:6443
CoreDNS is running at https://192.168.1.100:6443/api/v1/namespaces/kube-system/services/kube-dns:dns/proxy

To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.
```

### ヘッダー部

該当なし

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | コントロールプレーンURL | APIサーバのホストURL | restclient.Config.Host | `{名前} is running at {URL}` |
| 2 | クラスタサービスURL | クラスタサービスのプロキシURL | ServiceList（label: kubernetes.io/cluster-service=true） | `{名前} is running at {URL}` |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 案内メッセージ | cluster-info dumpへの誘導 | 固定文字列 | `To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.` |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | デフォルトはkube-system。`--namespace`で変更可能 | No |
| LabelSelector | 固定: `kubernetes.io/cluster-service=true` | Yes（自動設定） |

### ソート順

ServiceListの返却順に従う。

### 改ページ条件

改ページなし

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| REST Config | APIサーバのホストURL取得 | restClientGetter.ToRESTConfig() |
| Service (core/v1) | クラスタサービス一覧取得 | label: kubernetes.io/cluster-service=true |

### テーブル別参照項目詳細

#### restclient.Config

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| Host | コントロールプレーンURL | ToRESTConfig() | - |
| GroupVersion | サービスプロキシURL構築 | 同上 | Group/Version情報 |

#### Service (core/v1)

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | サービス名（フォールバック） | label: kubernetes.io/cluster-service=true | kubernetes.io/nameラベルが優先 |
| metadata.labels["kubernetes.io/name"] | サービス表示名 | 同上 | 空の場合はmetadata.nameを使用 |
| status.loadBalancer.ingress | LoadBalancer URL | 同上 | LoadBalancerタイプの場合 |
| spec.ports | ポート情報 | 同上 | プロキシURL構築に使用 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| サービスURL（LoadBalancer） | `http://{IP or Hostname}:{port}` | N/A | LoadBalancerのIngressが存在する場合 |
| サービスURL（プロキシ） | `{host}/api/{version}/namespaces/{ns}/services/{scheme:name:port}/proxy` | N/A | LoadBalancerがない場合。port.Nameが"https"またはport.Portが443の場合はschemeに"https"を設定 |
| サービス名 | `labels["kubernetes.io/name"]`が空の場合は`metadata.name`を使用 | N/A | - |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl cluster-info 実行] --> B[Complete: RESTConfig/Builder取得]
    B --> C[Run: Builder.Do で ServiceList取得]
    C --> D[printService: コントロールプレーンURL出力]
    D --> E{各サービスをループ}
    E --> F{LoadBalancer Ingress あり?}
    F -->|Yes| G[IP:Port でURL構築]
    F -->|No| H[APIサーバプロキシURLを構築]
    G --> I[printService: サービスURL出力]
    H --> I
    I --> E
    E -->|完了| J[案内メッセージ出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| REST設定エラー | kubeconfig読み込みに失敗した場合 | ToRESTConfigのエラーメッセージ | kubeconfig設定確認 |
| APIサーバ接続エラー | クラスタに接続できない場合 | Builder.Doのエラーメッセージ | ネットワーク・認証設定確認 |
| サービス取得エラー | ServiceListの取得に失敗した場合 | Visitのエラーメッセージ | 権限設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1〜10件程度（クラスタサービス数） |
| 目標出力時間 | APIサーバレスポンスに依存（通常1秒以内） |
| 同時出力数上限 | N/A（CLI単発実行） |

## セキュリティ考慮事項

クラスタのAPIサーバURLやサービスURLが表示されるため、クラスタのネットワーク構成情報が漏洩する可能性がある。出力先の管理に注意が必要。

## 備考

- 実装ファイル: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go`
- デフォルトNamespaceは`kube-system`
- `utilnet.JoinSchemeNamePort`でscheme:name:port形式のサービス名を構築
- `cluster-info dump`サブコマンドへの案内メッセージが必ず末尾に出力される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ClusterInfoOptionsの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | 49-56行目: ClusterInfoOptions構造体（IOStreams, Namespace, Builder, Client） |

#### Step 2: エントリーポイントを理解する

NewCmdClusterInfoとComplete/Runメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | 58-75行目: NewCmdClusterInfo（cobraコマンド定義、dumpサブコマンド追加） |
| 2-2 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | 77-92行目: Complete関数（RESTConfig取得、Namespace設定、Builder生成） |

**主要処理フロー**:
1. **79行目**: `restClientGetter.ToRESTConfig()`でRESTクライアント設定取得
2. **84-88行目**: Namespace指定がなければ`kube-system`をデフォルトに設定
3. **90行目**: resource.NewBuilderでResourceBuilder生成

#### Step 3: Run処理を理解する

サービス情報の取得とURL構築ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | 94-155行目: Run関数 |

**主要処理フロー**:
- **96-101行目**: Builder設定（scheme, namespace, labelSelector, resourceType）
- **106行目**: `printService(o.Out, "Kubernetes control plane", o.Client.Host)` でコントロールプレーンURL出力
- **108行目**: ServiceListをキャストして各サービスをループ
- **111-118行目**: LoadBalancer Ingressがある場合: IP:PortでURL構築
- **121-141行目**: Ingressがない場合: APIサーバプロキシURL構築（scheme判定含む）
- **143-147行目**: サービス名取得（kubernetes.io/nameラベル優先）とprintService呼び出し
- **151行目**: `cluster-info dump`案内メッセージ出力

#### Step 4: printServiceヘルパー関数

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | 157-162行目: printService関数（`{name} is running at {link}`形式で出力） |

### プログラム呼び出し階層図

```
kubectl cluster-info
    |
    +-- NewCmdClusterInfo() [clusterinfo.go:58]
    |       |
    |       +-- Complete() [clusterinfo.go:77]
    |       |       |
    |       |       +-- ToRESTConfig()
    |       |       +-- resource.NewBuilder()
    |       |
    |       +-- Run() [clusterinfo.go:94]
    |               |
    |               +-- Builder.Do().Visit()
    |               |       |
    |               |       +-- printService("Kubernetes control plane", host) [clusterinfo.go:106]
    |               |       |
    |               |       +-- 各Serviceのループ [clusterinfo.go:109]
    |               |               |
    |               |               +-- LoadBalancer URL構築 or プロキシURL構築
    |               |               +-- printService(name, link) [clusterinfo.go:147]
    |               |
    |               +-- 案内メッセージ出力 [clusterinfo.go:151]
    |
    +-- NewCmdClusterInfoDump() [サブコマンド]
```

### データフロー図

```
[入力]                         [処理]                              [出力]

RESTConfig.Host          -->  printService()                  -->  標準出力
(APIサーバURL)                                                      "Kubernetes control plane is running at ..."

ServiceList              -->  各ServiceのURL構築               -->  標準出力
(label=cluster-service)       |                                    "{name} is running at {url}"
                              +-- LoadBalancer or Proxy判定

固定文字列               -->  そのまま出力                      -->  標準出力
                                                                   "To further debug..."
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | ソース | cluster-infoコマンドの実装 |
| clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | ソース | cluster-info dumpサブコマンドの実装 |
| clusterinfo_dump_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump_test.go` | テスト | cluster-info dumpのテストケース |
