# 帳票設計書 7-Job一覧

## 概要

本ドキュメントは、Kubernetes の Job リソース一覧をテーブル形式で標準出力に出力する帳票の設計を定義する。`kubectl get jobs` コマンド実行時に使用される。

### 本帳票の処理概要

本帳票は、Kubernetes クラスタ上の Job リソースの一覧情報を、テーブル形式で標準出力に表示する処理を行う。

**業務上の目的・背景**：Job は 1 回限り、または指定回数の完了を保証するバッチ処理用リソースである。データ移行、バッチ集計、定期的なクリーンアップタスクなど、完了型のワークロードに使用される。運用者が Job の実行状態（Running / Complete / Failed / Suspended 等）、完了数、実行時間を一覧で確認し、バッチ処理の進行状況を監視するために本帳票が必要となる。

**帳票の利用シーン**：バッチ処理の実行状況確認、Job の完了/失敗状態の監視、実行時間の確認、並列実行状況の把握。

**主要な出力内容**：
1. Job 名（Name）
2. ステータス（Status）: Running, Complete, Failed, Suspended, Terminating, FailureTarget, SuccessCriteriaMet
3. 完了数（Completions）
4. 実行時間（Duration）
5. 作成からの経過時間（Age）
6. Wide 出力時: コンテナ名、イメージ名、セレクタ

**帳票の出力タイミング**：ユーザが `kubectl get jobs` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetes クラスタ管理者、バッチ処理運用者、データエンジニア。

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | ターミナル（CLI） | N/A | `kubectl get jobs [flags]` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 標準出力（テキスト / テーブル形式） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字（tabwriter） |
| ヘッダー表示 | デフォルト有効 |
| Wide 出力 | Containers, Images, Selector が追加（Priority=1） |

## 帳票レイアウト

### レイアウト概要

```
┌──────────────────────────────────────────────────────────────────┐
│  NAME       STATUS     COMPLETIONS   DURATION   AGE             │
├──────────────────────────────────────────────────────────────────┤
│  migrate    Complete   3/3           45s        2d              │
│  cleanup    Running    1/5           10m        1h              │
│  batch-1    Failed     0/1           5m         3d              │
└──────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | Job の名前 | `obj.ObjectMeta.Name` | 文字列（name フォーマット） |
| 2 | Status | Job のステータス | `obj.Status.Conditions` + `obj.ObjectMeta.DeletionTimestamp` | 文字列（複合ロジック） |
| 3 | Completions | 完了数 / 目標数 | `obj.Status.Succeeded` / `obj.Spec.Completions` | `{succeeded}/{completions}` 形式 |
| 4 | Duration | 実行時間 | `obj.Status.StartTime`, `obj.Status.CompletionTime` | `duration.HumanDuration` |
| 5 | Age | 経過時間 | `obj.ObjectMeta.CreationTimestamp` | `translateTimestampSince` |

### 明細部（Wide 出力時の追加カラム）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 6 | Containers | コンテナ名一覧 | `obj.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 7 | Images | イメージ名一覧 | `obj.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 8 | Selector | Pod セレクタ | `obj.Spec.Selector` | LabelSelector 文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象 Namespace | No |
| All Namespaces | 全 Namespace | No |
| Label Selector | ラベルフィルタ | No |
| Field Selector | フィールドフィルタ | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Job 名（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: `/registry/jobs/{namespace}/{name}` | Job オブジェクトの永続化ストア | N/A |

### テーブル別参照項目詳細

#### Job リソース（API: `batch/v1/jobs`）

| 参照項目（フィールド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | N/A | Job の名前 |
| `metadata.creationTimestamp` | Age | N/A | 経過時間に変換 |
| `metadata.deletionTimestamp` | Status | N/A | 設定時 "Terminating" |
| `spec.completions` | Completions (分母) | N/A | nil の場合は並列数に基づく表示 |
| `spec.parallelism` | Completions (並列表示) | N/A | Completions nil かつ Parallelism > 1 時 |
| `spec.template.spec.containers` | Containers, Images (wide) | N/A | layoutContainerCells |
| `spec.selector` | Selector (wide) | N/A | metav1.FormatLabelSelector |
| `status.succeeded` | Completions (分子) | N/A | 成功 Pod 数 |
| `status.conditions` | Status | N/A | JobComplete, JobFailed, JobSuspended 等 |
| `status.startTime` | Duration | N/A | 実行時間の起点 |
| `status.completionTime` | Duration | N/A | 実行時間の終点 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Status | 複合条件（詳細後述） | N/A | Conditions の判定順序に依存 |
| Completions | `Spec.Completions != nil ? "{Succeeded}/{Completions}" : "{Succeeded}/1 of {Parallelism}"` | N/A | Parallelism > 1 時のみ "of N" 付き |
| Duration (実行中) | `time.Since(StartTime)` | HumanDuration | CompletionTime が nil の場合 |
| Duration (完了) | `CompletionTime - StartTime` | HumanDuration | 両方設定されている場合 |
| Duration (未開始) | 空文字列 | N/A | StartTime が nil の場合 |

#### Status 算出ロジック詳細

以下の優先順位で判定される（行 1252-1266）:

1. `JobComplete` 条件が True: "Complete"
2. `JobFailed` 条件が True: "Failed"
3. `DeletionTimestamp` が設定済み: "Terminating"
4. `JobSuspended` 条件が True: "Suspended"
5. `JobFailureTarget` 条件が True: "FailureTarget"
6. `JobSuccessCriteriaMet` 条件が True: "SuccessCriteriaMet"
7. 上記いずれでもない: "Running"

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get jobs 実行] --> B[API サーバへリクエスト]
    B --> C[Job リスト取得]
    C --> D[printJobList]
    D --> E[printJob で各行生成]
    E --> F{Status 判定}
    F -->|Complete| G[Complete]
    F -->|Failed| H[Failed]
    F -->|DeletionTimestamp| I[Terminating]
    F -->|Suspended| J[Suspended]
    F -->|その他| K[Running]
    G --> L[HumanReadablePrinter でテーブル出力]
    H --> L
    I --> L
    J --> L
    K --> L
    L --> M[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | Job が存在しない | `No resources found in {namespace} namespace.` | 条件見直し |
| API エラー | 接続失敗 | API エラーメッセージ | kubeconfig 確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数千件 |
| 目標出力時間 | 即時 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

- Job 一覧取得には `jobs` リソース（batch グループ）の `list` / `get` 権限が必要

## 備考

- Completions の表示は Spec.Completions の設定有無で異なる
  - 設定あり: `{succeeded}/{completions}`
  - 設定なし、Parallelism <= 1: `{succeeded}/1`
  - 設定なし、Parallelism > 1: `{succeeded}/1 of {parallelism}`
- Status 判定は hasJobCondition ヘルパー関数を使用（行 1096-1103）
- FailureTarget と SuccessCriteriaMet は比較的新しい条件タイプ

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | jobColumnDefinitions（行 171-179）: Name, Status, Completions, Duration, Age + wide: Containers, Images, Selector |

**読解のコツ**: Job の Status カラムは Pod の Status と異なり、Conditions に基づく簡潔な文字列。Duration は他のリソースにはない独自カラム。

#### Step 2: print 関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printJob`（行 1224-1274）: Completions の表示ロジック、Duration の算出、Status の判定 |
| 2-2 | printers.go | `pkg/printers/internalversion/printers.go` | `hasJobCondition`（行 1096-1103）: Job Conditions のチェックヘルパー |
| 2-3 | printers.go | `pkg/printers/internalversion/printers.go` | `printJobList`（行 1276-1286）: Items を順に委譲 |

**主要処理フロー**:
- **行 1230-1242**: Completions 表示文字列の組み立て（Spec.Completions の nil 判定、Parallelism の考慮）
- **行 1243-1250**: Duration の算出（StartTime nil / CompletionTime nil / 両方ありの 3 パターン）
- **行 1251-1266**: Status の判定（Complete > Failed > Terminating > Suspended > FailureTarget > SuccessCriteriaMet > Running）
- **行 1268**: Name, Status, Completions, Duration, Age をセルに追加
- **行 1269-1272**: Wide 時にコンテナ情報とセレクタを追加

### プログラム呼び出し階層図

```
kubectl get jobs
    |
    +-- GetOptions.Run() [get.go]
           |
           +-- API Server Request
           |       |
           |       +-- printJobList() [printers.go 行1276]
           |               |
           |               +-- printJob() [printers.go 行1224]
           |                       |
           |                       +-- hasJobCondition() [printers.go 行1096]
           |                       +-- duration.HumanDuration()
           |                       +-- layoutContainerCells() (wide)
           |                       +-- metav1.FormatLabelSelector() (wide)
           |
           +-- HumanReadablePrinter.PrintObj()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

API Server (etcd)          printJob()                         標準出力 (stdout)
  Job Object           --> - Completions 表示組み立て      --> テーブル形式テキスト
  (batch.Job)              - Duration 算出                     NAME STATUS COMPLETIONS ...
                           - Status 条件判定                   job1 Complete 3/3 45s 2d
                           - TableRow 生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | Job 用カラム定義と print 関数（行 171-182, 1096-1103, 1224-1286） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルレンダリング |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl get コマンドエントリーポイント |
