# 帳票設計書 70-クラスタ情報ダンプ

## 概要

本ドキュメントは、Kubernetesクラスタの詳細な診断情報をディレクトリ構造にダンプ出力する帳票の設計書である。`kubectl cluster-info dump` コマンド実行時に、クラスタ内のノード情報、各Namespace内のリソース（Event, ReplicationController, Service, DaemonSet, Deployment, ReplicaSet, Pod）およびPodログをJSON/YAML/テキスト形式でファイルまたは標準出力に出力する。

### 本帳票の処理概要

**業務上の目的・背景**：Kubernetesクラスタで問題が発生した際に、クラスタ全体の状態をスナップショットとして保存し、後から詳細な分析やサポートチームとの共有を行う必要がある。cluster-info dumpはクラスタの包括的な診断情報を一括で収集するコマンドであり、トラブルシューティングの初期段階で重要な役割を果たす。

**帳票の利用シーン**：クラスタの障害調査時に診断情報を一括収集する場合、サポートチームに提出する診断バンドルを作成する場合、クラスタの状態を定期的にバックアップする場合、特定のNamespaceに限定して診断情報を収集する場合に利用される。

**主要な出力内容**：
1. ノード一覧（全クラスタ）
2. Namespace別リソース一覧（Events, ReplicationControllers, Services, DaemonSets, Deployments, ReplicaSets, Pods）
3. Pod別コンテナログ（InitContainerとContainerの両方）
4. 出力先はstdoutまたは指定ディレクトリ

**帳票の出力タイミング**：`kubectl cluster-info dump` コマンド実行時に即座に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、サポートエンジニア、SRE。

## 帳票種別

診断レポート（クラスタダンプ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（ターミナル） | - | `kubectl cluster-info dump` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON（デフォルト）/ YAML / テキスト |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | ディレクトリ構造（下記参照） |
| 出力方法 | 標準出力（デフォルト）またはディレクトリ出力（`--output-directory`指定時） |
| 文字コード | UTF-8 |

### ディレクトリ構造（`--output-directory`指定時）

```
<output-directory>/
    nodes.json
    <namespace>/
        events.json
        replication-controllers.json
        services.json
        daemonsets.json
        deployments.json
        replicasets.json
        pods.json
        <pod-name>/
            logs.txt
```

## 帳票レイアウト

### レイアウト概要

各リソースの完全なJSON/YAML表現をファイルに出力する。ログはテキスト形式で、コンテナごとにSTART/ENDマーカーで区切られる。

```
==== START logs for container nginx of pod default/nginx-pod ====
... (ログ内容) ...
==== END logs for container nginx of pod default/nginx-pod ====
```

### ヘッダー部

該当なし

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Nodes | 全ノード一覧 | CoreClient.Nodes().List() | JSON/YAML |
| 2 | Events | Namespace別イベント | CoreClient.Events(ns).List() | JSON/YAML |
| 3 | ReplicationControllers | Namespace別RC | CoreClient.ReplicationControllers(ns).List() | JSON/YAML |
| 4 | Services | Namespace別サービス | CoreClient.Services(ns).List() | JSON/YAML |
| 5 | DaemonSets | Namespace別DaemonSet | AppsClient.DaemonSets(ns).List() | JSON/YAML |
| 6 | Deployments | Namespace別Deployment | AppsClient.Deployments(ns).List() | JSON/YAML |
| 7 | ReplicaSets | Namespace別ReplicaSet | AppsClient.ReplicaSets(ns).List() | JSON/YAML |
| 8 | Pods | Namespace別Pod | CoreClient.Pods(ns).List() | JSON/YAML |
| 9 | Container Logs | Pod別コンテナログ | LogsForObject() | テキスト |

### フッター部

| No | 項目名 | 説明 |
|----|-------|------|
| 1 | 完了メッセージ | `Cluster info dumped to {directory}`（ディレクトリ出力時のみ） |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| --output-directory | 出力先ディレクトリ（空または"-"の場合はstdout） | No |
| --namespaces | ダンプ対象Namespace（カンマ区切り） | No |
| --all-namespaces | 全Namespaceをダンプ | No |
| --output | 出力フォーマット（json/yaml等、デフォルトjson） | No |
| --pod-running-timeout | Podログ取得のタイムアウト（デフォルト20秒） | No |

### ソート順

APIサーバが返すデフォルト順序に従う。

### 改ページ条件

改ページなし。Namespace/Pod/Container単位でファイルが分割される。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| Node (core/v1) | ノード一覧 | 全ノード |
| Event (core/v1) | Namespace別イベント | Namespace指定 |
| ReplicationController (core/v1) | Namespace別RC | Namespace指定 |
| Service (core/v1) | Namespace別サービス | Namespace指定 |
| DaemonSet (apps/v1) | Namespace別DaemonSet | Namespace指定 |
| Deployment (apps/v1) | Namespace別Deployment | Namespace指定 |
| ReplicaSet (apps/v1) | Namespace別ReplicaSet | Namespace指定 |
| Pod (core/v1) | Namespace別Pod | Namespace指定 |
| PodLog | Pod別コンテナログ | Pod名+Container名 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ファイル拡張子 | JSON→".json"、YAML→".yaml"、その他→".txt" | N/A | OutputFormatから判定 |
| Namespace一覧 | AllNamespaces: 全Namespace取得。Namespaces指定: 指定リスト。両方なし: kube-system + 現在のNamespace | N/A | - |
| ファイルパス | `filepath.Join(dir, filename) + fileExtension` | N/A | ディレクトリは自動作成（0755） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl cluster-info dump 実行] --> B[Complete: Printer/Client/Timeout設定]
    B --> C[Run: ノード一覧取得・出力]
    C --> D{Namespace一覧決定}
    D -->|AllNamespaces| E[全Namespace取得]
    D -->|Namespaces指定| F[指定リスト使用]
    D -->|指定なし| G[kube-system + 現在Namespace]
    E --> H[各Namespaceループ]
    F --> H
    G --> H
    H --> I[Events取得・出力]
    I --> J[ReplicationControllers取得・出力]
    J --> K[Services取得・出力]
    K --> L[DaemonSets取得・出力]
    L --> M[Deployments取得・出力]
    M --> N[ReplicaSets取得・出力]
    N --> O[Pods取得・出力]
    O --> P[各Podのログ取得]
    P --> Q[InitContainer + Containerのログ出力]
    Q --> H
    H -->|完了| R{OutputDir指定?}
    R -->|Yes| S[完了メッセージ出力]
    R -->|No| T[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| クライアント初期化エラー | REST設定取得失敗 | NewForConfigのエラーメッセージ | kubeconfig設定確認 |
| ノード一覧取得エラー | Nodeリソースへのアクセス権限がない場合 | List Nodesのエラーメッセージ | RBAC設定確認 |
| リソース取得エラー | 特定リソースへのアクセス権限がない場合 | List {Resource}のエラーメッセージ | RBAC設定確認 |
| ログ取得エラー | Podログの取得に失敗した場合 | `Create log request error: ...` または `Request log error: ...` | Pod状態確認 |
| ファイル作成エラー | 出力ディレクトリへの書き込み権限がない場合 | os.Createのエラーメッセージ | ディレクトリ権限確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | クラスタ規模に依存（数十〜数万件） |
| 目標出力時間 | クラスタ規模とネットワーク帯域に依存（数秒〜数分） |
| 同時出力数上限 | N/A（CLI単発実行） |
| ログ取得タイムアウト | 5分（timeout定数） |
| Pod実行タイムアウト | デフォルト20秒（defaultPodLogsTimeout） |

## セキュリティ考慮事項

cluster-info dumpはクラスタ内の広範な情報を出力するため、以下に注意が必要:
- Podログには機密情報が含まれる可能性がある
- リソースのJSON/YAMLにはSecretデータが含まれる可能性がある
- 出力ディレクトリのアクセス権限は0755で作成される
- ダンプファイルの保管・共有時は機密情報のマスキングを検討すべき

## 備考

- 実装ファイル: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go`
- デフォルト出力形式はJSON（`PrintFlags.WithDefaultOutput("json")`）
- デフォルトのダンプ対象Namespace: kube-system + 現在のNamespace
- `--all-namespaces`指定時は`--namespaces`が無視される
- ログ出力はコンテナごとにSTART/ENDマーカーで区切られる
- `polymorphichelpers.LogsForObjectFn`を使用してPodログを取得

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ClusterInfoDumpOptionsの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | 49-65行目: ClusterInfoDumpOptions構造体（PrintFlags, OutputDir, AllNamespaces, Namespaces, Timeout, AppsClient, CoreClient等） |

**読解のコツ**: PrintFlagsは汎用的な出力形式制御を提供し、PrintObjはResourcePrinterFuncとして実際のプリンター関数を保持する。

#### Step 2: エントリーポイントを理解する

NewCmdClusterInfoDumpとComplete関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | 67-92行目: NewCmdClusterInfoDump（コマンド定義とフラグ登録） |
| 2-2 | clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | 131-168行目: Complete関数 |

**主要処理フロー**:
1. **69行目**: `PrintFlags.WithDefaultOutput("json")`でデフォルト出力形式をJSONに設定
2. **87行目**: `--output-directory`フラグ登録
3. **132行目**: `o.PrintFlags.ToPrinter()`でプリンター生成
4. **144行目**: `corev1client.NewForConfig`でCoreV1クライアント生成
5. **149行目**: `appsv1client.NewForConfig`でAppsV1クライアント生成

#### Step 3: Run処理を理解する

メインのダンプ処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | 170-311行目: Run関数 |

**主要処理フロー**:
- **171行目**: ノード一覧取得
- **176-184行目**: ファイル拡張子判定（json→.json, yaml→.yaml, その他→.txt）
- **186行目**: ノード一覧出力
- **190-208行目**: Namespace一覧決定（AllNamespaces/指定/デフォルト）
- **209-303行目**: 各Namespaceループ（Events→RC→Services→DaemonSets→Deployments→ReplicaSets→Pods→ログ）
- **269-302行目**: printContainer関数（コンテナログの取得と出力。START/ENDマーカー付き）
- **306-309行目**: 出力先ディレクトリの完了メッセージ

#### Step 4: setupOutputWriterヘルパー関数

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | 118-129行目: setupOutputWriter関数（ディレクトリ指定時はファイル作成、それ以外はデフォルトWriter返却） |

### プログラム呼び出し階層図

```
kubectl cluster-info dump
    |
    +-- NewCmdClusterInfoDump() [clusterinfo_dump.go:67]
    |       |
    |       +-- Complete() [clusterinfo_dump.go:131]
    |       |       |
    |       |       +-- PrintFlags.ToPrinter()
    |       |       +-- corev1client.NewForConfig()
    |       |       +-- appsv1client.NewForConfig()
    |       |
    |       +-- Run() [clusterinfo_dump.go:170]
    |               |
    |               +-- CoreClient.Nodes().List() → PrintObj [171行目]
    |               |
    |               +-- Namespace一覧決定 [190行目]
    |               |
    |               +-- 各Namespaceループ [209行目]
    |                       |
    |                       +-- CoreClient.Events(ns).List() → PrintObj
    |                       +-- CoreClient.ReplicationControllers(ns).List() → PrintObj
    |                       +-- CoreClient.Services(ns).List() → PrintObj
    |                       +-- AppsClient.DaemonSets(ns).List() → PrintObj
    |                       +-- AppsClient.Deployments(ns).List() → PrintObj
    |                       +-- AppsClient.ReplicaSets(ns).List() → PrintObj
    |                       +-- CoreClient.Pods(ns).List() → PrintObj
    |                       |
    |                       +-- 各Podのログ取得
    |                               |
    |                               +-- printContainer() [269行目]
    |                                       |
    |                                       +-- LogsForObject() → DoRaw()
    |
    +-- setupOutputWriter() [118行目]
            |
            +-- os.MkdirAll(parent, 0755)
            +-- os.Create(fullFile)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

Kubernetes API             -->  CoreClient/AppsClient          -->  ファイル or stdout
(Nodes, Events, Pods等)         .List()                             (JSON/YAML形式)

Pod コンテナ               -->  LogsForObject()                -->  ログファイル or stdout
                                .DoRaw()                            (テキスト形式)

PrintFlags                 -->  setupOutputWriter()             -->  ディレクトリ構造
(--output, --output-dir)        filepath.Join + os.Create           (<dir>/<ns>/<resource>.<ext>)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | ソース | cluster-info dumpコマンドのメイン実装 |
| clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | ソース | 親コマンド（cluster-info）の実装 |
| clusterinfo_dump_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump_test.go` | テスト | cluster-info dumpのテストケース |
| json.go | `staging/src/k8s.io/cli-runtime/pkg/printers/json.go` | ソース | デフォルト出力形式（JSON）のプリンター |
| yaml.go | `staging/src/k8s.io/cli-runtime/pkg/printers/yaml.go` | ソース | YAML出力形式のプリンター |
