# 帳票設計書 71-Nodeリソース使用状況

## 概要

本ドキュメントは、Kubernetesクラスタ内のNodeリソース使用状況（CPU/メモリ/スワップ）をテーブル形式で標準出力に出力する帳票の設計書である。`kubectl top node` コマンドとして提供される。

### 本帳票の処理概要

本帳票は、Kubernetesクラスタに所属する各Nodeのリソース消費状況をリアルタイムに一覧表示する機能を提供する。

**業務上の目的・背景**：Kubernetesクラスタの運用において、各Nodeがどの程度のCPU・メモリリソースを消費しているかを把握することは、キャパシティプランニングやパフォーマンストラブルシューティングの基本である。本帳票は、Metrics Server から取得したメトリクスデータを元に、Nodeごとの使用量と使用率を一覧形式で表示し、運用者がクラスタのリソース状況を迅速に確認できるようにすることを目的としている。

**帳票の利用シーン**：クラスタ管理者がNodeのリソース使用状況をスポットチェックする場合に利用される。例えば、特定のNodeに負荷が集中していないかの確認、HPA/VPAの動作検証時のリソース消費パターンの確認、キャパシティ不足の早期検知などに使用される。

**主要な出力内容**：
1. Node名（NAME）
2. CPU使用量（CPU(cores)）: ミリコア単位
3. CPU使用率（CPU(%)）: Allocatable/Capacityに対する割合
4. メモリ使用量（MEMORY(bytes)）: MiB単位
5. メモリ使用率（MEMORY(%)）: Allocatable/Capacityに対する割合
6. スワップ使用量（SWAP(bytes)）: --show-swapオプション時のみ、MiB単位
7. スワップ使用率（SWAP(%)）: --show-swapオプション時のみ

**帳票の出力タイミング**：ユーザが `kubectl top node` コマンドを実行した時点で即座に出力される。

**帳票の利用者**：クラスタ管理者、SRE、インフラエンジニア

## 帳票種別

一覧表（メトリクスサマリ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl top node [NAME \| -l label]` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（タブ区切りテーブル） |
| 用紙サイズ | N/A（標準出力） |
| 向き | N/A |
| ファイル名 | N/A（stdout） |
| 出力方法 | 標準出力（stdout）へのストリーム出力 |
| 文字コード | UTF-8 |

### テーブル出力仕様

| 項目 | 内容 |
|-----|------|
| 区切り文字 | タブ文字（tabwriter使用） |
| ヘッダー | デフォルト表示、--no-headersで非表示 |
| ソート | --sort-byでcpu/memoryによるソート可能 |

## 帳票レイアウト

### レイアウト概要

メトリクスが取得できたNodeについてリソース使用状況を1行1Nodeで表示し、メトリクスが取得できなかったNodeについては `<unknown>` を表示する。

```
┌──────────────────────────────────────────────────────────────────────┐
│  ヘッダー行（--no-headersで省略可）                                    │
├──────────────────────────────────────────────────────────────────────┤
│  NAME    CPU(cores)  CPU(%)  MEMORY(bytes)  MEMORY(%)               │
│  node1   250m        12%     1024Mi         25%                      │
│  node2   500m        25%     2048Mi         50%                      │
│  node3   <unknown>   <unknown> <unknown>    <unknown>                │
└──────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | Node名 | NodeMetrics.Name | 文字列 |
| 2 | CPU(cores) | CPU使用量 | NodeMetrics.Usage[cpu] | {値}m（ミリコア） |
| 3 | CPU(%) | CPU使用率 | Usage / Allocatable * 100 | {値}%（整数） |
| 4 | MEMORY(bytes) | メモリ使用量 | NodeMetrics.Usage[memory] | {値}Mi |
| 5 | MEMORY(%) | メモリ使用率 | Usage / Allocatable * 100 | {値}%（整数） |
| 6 | SWAP(bytes) | スワップ使用量（--show-swap時） | NodeMetrics.Usage[swap] | {値}Mi |
| 7 | SWAP(%) | スワップ使用率（--show-swap時） | Usage / NodeInfo.Swap.Capacity * 100 | {値}%（整数） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | NAME | Node名 | NodeMetrics.Name | 文字列 | 可変（tabwriter） |
| 2 | CPU(cores) | CPU使用量 | NodeMetrics.Usage[cpu].MilliValue() | {値}m | 可変 |
| 3 | CPU(%) | CPU使用率 | 計算値 | {値}% | 可変 |
| 4 | MEMORY(bytes) | メモリ使用量 | NodeMetrics.Usage[memory].Value()/(1024*1024) | {値}Mi | 可変 |
| 5 | MEMORY(%) | メモリ使用率 | 計算値 | {値}% | 可変 |

### フッター部

本帳票にフッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ResourceName | 特定のNode名を指定して絞り込み | No |
| Selector (-l) | ラベルセレクタによるNode絞り込み | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | --sort-by=cpu: CPU使用量 | 降順 |
| 1 | --sort-by=memory: メモリ使用量 | 降順 |
| - | デフォルト: Metrics APIからの返却順 | - |

### 改ページ条件

改ページは発生しない（標準出力へのストリーム出力）。

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースではなくKubernetes APIを参照する。

| API | 用途 | 結合条件 |
|-----|------|---------|
| Metrics API (v1beta1) NodeMetricses | Nodeのリソース使用量取得 | Node名で結合 |
| Core API v1 Nodes | NodeのAllocatable/Capacity取得 | Node名で結合 |

### テーブル別参照項目詳細

#### Metrics API - NodeMetrics

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| Name | NAME | ResourceName指定時は単一Get、それ以外はList | ラベルセレクタ適用可 |
| Usage[cpu] | CPU(cores) | - | MilliValue()で取得 |
| Usage[memory] | MEMORY(bytes) | - | Value()/(1024*1024)でMiB変換 |

#### Core API - Node

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| Status.Allocatable | CPU(%),MEMORY(%)の分母 | --show-capacity未指定時 | デフォルト |
| Status.Capacity | CPU(%),MEMORY(%)の分母 | --show-capacity指定時 | - |
| Status.NodeInfo.Swap.Capacity | SWAP(%)の分母 | --show-swap指定時 | nil時は`<unknown>`表示 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| CPU(%) | Usage[cpu].MilliValue() / Allocatable[cpu].MilliValue() * 100 | 切り捨て（int64キャスト） | Allocatableが0の場合は0% |
| MEMORY(%) | Usage[memory].MilliValue() / Allocatable[memory].MilliValue() * 100 | 切り捨て（int64キャスト） | Allocatableが0の場合は0% |
| SWAP(%) | Usage[swap].MilliValue() / SwapCapacity.MilliValue() * 100 | 切り捨て（int64キャスト） | SwapCapacityがnil時は`<unknown>` |
| MEMORY(bytes)表示値 | Usage[memory].Value() / (1024 * 1024) | 整数除算（切り捨て） | MiB単位で表示 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl top node コマンド実行] --> B[Complete: クライアント初期化]
    B --> C[Validate: パラメータ検証]
    C --> D[RunTopNode: Metrics API可用性確認]
    D --> E{Metrics API利用可能?}
    E -->|No| F[エラー: Metrics API not available]
    E -->|Yes| G[getNodeMetricsFromMetricsAPI: メトリクス取得]
    G --> H{メトリクス件数 > 0?}
    H -->|No| I[エラー: metrics not available yet]
    H -->|Yes| J[Node情報取得（Allocatable/Capacity）]
    J --> K[PrintNodeMetrics: テーブル出力]
    K --> L[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| Metrics API未対応 | クラスタにMetrics Serverが未導入 | "Metrics API not available" | Metrics Serverをインストール |
| メトリクス未取得 | メトリクスデータが0件 | "metrics not available yet" | Metrics Serverの稼働確認、時間を置いて再実行 |
| パラメータエラー | --sort-byにcpu/memory以外を指定 | "--sort-by accepts only cpu or memory" | cpu/memoryのいずれかを指定 |
| パラメータエラー | NAMEと-lを同時指定 | "only one of NAME or --selector can be provided" | いずれか一方のみ指定 |
| API接続エラー | Kubernetes APIに接続不可 | 各種接続エラーメッセージ | kubeconfig/接続先確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数千Node |
| 目標出力時間 | Metrics API応答速度に依存（通常数秒以内） |
| 同時出力数上限 | CLIコマンドのため制限なし |

## セキュリティ考慮事項

- Metrics APIへのアクセスにはRBACによる適切な権限が必要（nodes/metrics リソースへのget/list権限）
- `--use-protocol-buffers`オプション（デフォルト有効）によりprotobuf形式で通信し、転送効率を向上
- 出力データにはNode名とリソース使用量のみが含まれ、機密情報は含まれない

## 備考

- Metrics Serverは別途クラスタにインストールが必要（metrics.k8s.io APIグループ）
- 対応するMetrics APIバージョンは v1beta1 のみ
- `--show-capacity`オプション指定時はAllocatableではなくCapacityベースでパーセンテージを計算
- メトリクスが取得できないNodeも、Allocatable/Capacity情報は表示される（使用量は`<unknown>`）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、帳票出力に使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | top_node.go | `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` | TopNodeOptions構造体（行41-56）でコマンドオプションの全体像を把握 |
| 1-2 | metrics_printer.go | `staging/src/k8s.io/kubectl/pkg/metricsutil/metrics_printer.go` | ResourceMetricsInfo構造体（行38-42）とTopCmdPrinter構造体（行44-51）でデータモデルを理解 |

**読解のコツ**: TopNodeOptions はcobraコマンドの全オプションを保持し、Complete/Validate/RunTopNodeの3段階で処理が進む。

#### Step 2: エントリーポイントを理解する

処理の起点となるコマンド登録と実行フローを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | top.go | `staging/src/k8s.io/kubectl/pkg/cmd/top/top.go` | NewCmdTop関数（行69-82）でtopコマンドのサブコマンド構成を確認 |
| 2-2 | top_node.go | `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` | NewCmdTopNode関数（行72-102）でコマンドフラグ定義を確認 |

**主要処理フロー**:
1. **行87-90**: Run関数内でComplete -> Validate -> RunTopNode の順に実行
2. **行104-134**: Complete関数でMetricsClient、NodeClient、Printerを初期化
3. **行148-214**: RunTopNode関数でメトリクス取得からテーブル出力まで実行

#### Step 3: メトリクス取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | top_node.go | `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` | getNodeMetricsFromMetricsAPI関数（行216-239）でMetrics APIからのデータ取得を理解 |
| 3-2 | top.go | `staging/src/k8s.io/kubectl/pkg/cmd/top/top.go` | SupportedMetricsAPIVersionAvailable関数（行84-98）でAPI可用性チェックを理解 |

**主要処理フロー**:
- **行216-239**: v1beta1 NodeMetricses APIからGet/Listでメトリクスを取得し、内部型に変換

#### Step 4: 出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | metrics_printer.go | `staging/src/k8s.io/kubectl/pkg/metricsutil/metrics_printer.go` | PrintNodeMetrics関数（行74-103）でNodeメトリクスのテーブル出力処理を理解 |
| 4-2 | metrics_printer.go | `staging/src/k8s.io/kubectl/pkg/metricsutil/metrics_printer.go` | printAllResourceUsages関数（行224-242）とprintSingleResourceUsage関数（行244-253）で値のフォーマット処理を理解 |

**主要処理フロー**:
- **行74-103**: ソート -> ヘッダー出力 -> 各Node行出力 -> メトリクス未取得Node出力
- **行244-253**: CPU はミリコア(m)、メモリ/スワップはMiB単位で表示

### プログラム呼び出し階層図

```
NewCmdTop (top.go:69)
    |
    +-- NewCmdTopNode (top_node.go:72)
            |
            +-- Complete (top_node.go:104)
            |       +-- KubernetesClientSet
            |       +-- metricsclientset.NewForConfig
            |       +-- NewTopCmdPrinter (metrics_printer.go:53)
            |
            +-- Validate (top_node.go:136)
            |
            +-- RunTopNode (top_node.go:148)
                    +-- SupportedMetricsAPIVersionAvailable (top.go:84)
                    +-- getNodeMetricsFromMetricsAPI (top_node.go:216)
                    |       +-- MetricsV1beta1().NodeMetricses().Get/List
                    |       +-- Convert_v1beta1_NodeMetricsList_To_metrics_NodeMetricsList
                    +-- NodeClient.Nodes().Get/List
                    +-- PrintNodeMetrics (metrics_printer.go:74)
                            +-- NewNodeMetricsSorter / sort.Sort
                            +-- printColumnNames (metrics_printer.go:155)
                            +-- printMetricsLine (metrics_printer.go:204)
                            |       +-- printAllResourceUsages (metrics_printer.go:224)
                            |               +-- printSingleResourceUsage (metrics_printer.go:244)
                            +-- printMissingMetricsNodeLine (metrics_printer.go:210)
```

### データフロー図

```
[入力]                       [処理]                              [出力]

Metrics API               RunTopNode()
(NodeMetrics) ---------> getNodeMetricsFromMetricsAPI() ----+
                                                             |
Core API                                                     +--> PrintNodeMetrics() --> stdout
(Node.Status) ---------> Nodes().Get/List ()-----------------+    (タブ区切りテーブル)
                          Allocatable/Capacity取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| top.go | `staging/src/k8s.io/kubectl/pkg/cmd/top/top.go` | ソース | topコマンド親定義、API可用性チェック |
| top_node.go | `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` | ソース | top nodeサブコマンド本体 |
| metrics_printer.go | `staging/src/k8s.io/kubectl/pkg/metricsutil/metrics_printer.go` | ソース | メトリクステーブル出力ロジック |
| metrics_sorter.go | `staging/src/k8s.io/kubectl/pkg/metricsutil/metrics_sorter.go` | ソース | メトリクスソート処理 |
