# 帳票設計書 8-CronJob一覧

## 概要

本ドキュメントは、Kubernetes の CronJob リソース一覧をテーブル形式で標準出力に出力する帳票の設計を定義する。`kubectl get cronjobs` コマンド実行時に使用される。

### 本帳票の処理概要

本帳票は、Kubernetes クラスタ上の CronJob リソースの一覧情報を、テーブル形式で標準出力に表示する処理を行う。

**業務上の目的・背景**：CronJob は cron スケジュールに基づいて定期的に Job を生成するリソースである。定期バッチ処理、レポート生成、データクリーンアップなどの周期的なタスクのスケジュール管理に使用される。運用者がスケジュール設定、一時停止状態、アクティブな Job 数、最終スケジュール時刻を一覧で確認し、定期バッチの正常稼働を監視するために本帳票が必要となる。

**帳票の利用シーン**：定期バッチの一覧確認、スケジュール設定の監査、一時停止/再開状態の確認、最終実行時刻の確認、タイムゾーン設定の確認。

**主要な出力内容**：
1. CronJob 名（Name）
2. cron スケジュール（Schedule）
3. タイムゾーン（Timezone）
4. 一時停止フラグ（Suspend）
5. アクティブ Job 数（Active）
6. 最終スケジュール時刻（Last Schedule）
7. 作成からの経過時間（Age）
8. Wide 出力時: コンテナ名、イメージ名、セレクタ

**帳票の出力タイミング**：ユーザが `kubectl get cronjobs` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetes クラスタ管理者、バッチ処理運用者。

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | ターミナル（CLI） | N/A | `kubectl get cronjobs [flags]` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 標準出力（テキスト / テーブル形式） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字（tabwriter） |
| ヘッダー表示 | デフォルト有効 |
| Wide 出力 | Containers, Images, Selector が追加（Priority=1） |

## 帳票レイアウト

### レイアウト概要

```
┌────────────────────────────────────────────────────────────────────────────────────┐
│  NAME       SCHEDULE      TIMEZONE     SUSPEND   ACTIVE   LAST SCHEDULE   AGE     │
├────────────────────────────────────────────────────────────────────────────────────┤
│  backup     */5 * * * *   Asia/Tokyo   False     1        2m              30d     │
│  cleanup    0 3 * * *     <none>       True      0        <none>          15d     │
└────────────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | CronJob の名前 | `obj.ObjectMeta.Name` | 文字列（name フォーマット） |
| 2 | Schedule | cron スケジュール式 | `obj.Spec.Schedule` | cron 式文字列 |
| 3 | Timezone | タイムゾーン | `obj.Spec.TimeZone` | 文字列、未設定時は `<none>` |
| 4 | Suspend | 一時停止フラグ | `obj.Spec.Suspend` | `printBoolPtr` で "True"/"False" |
| 5 | Active | アクティブ Job 数 | `obj.Status.Active` | 整数（int64）: `len(obj.Status.Active)` |
| 6 | Last Schedule | 最終スケジュール時刻 | `obj.Status.LastScheduleTime` | `translateTimestampSince`、未設定時は `<none>` |
| 7 | Age | 経過時間 | `obj.ObjectMeta.CreationTimestamp` | `translateTimestampSince` |

### 明細部（Wide 出力時の追加カラム）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 8 | Containers | コンテナ名一覧 | `obj.Spec.JobTemplate.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 9 | Images | イメージ名一覧 | `obj.Spec.JobTemplate.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 10 | Selector | Pod セレクタ | `obj.Spec.JobTemplate.Spec.Selector` | LabelSelector 文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象 Namespace | No |
| All Namespaces | 全 Namespace | No |
| Label Selector | ラベルフィルタ | No |
| Field Selector | フィールドフィルタ | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | CronJob 名（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: `/registry/cronjobs/{namespace}/{name}` | CronJob オブジェクトの永続化ストア | N/A |

### テーブル別参照項目詳細

#### CronJob リソース（API: `batch/v1/cronjobs`）

| 参照項目（フィールド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | N/A | CronJob の名前 |
| `metadata.creationTimestamp` | Age | N/A | 経過時間に変換 |
| `spec.schedule` | Schedule | N/A | cron 式文字列 |
| `spec.timeZone` | Timezone | N/A | *string 型、nil なら "<none>" |
| `spec.suspend` | Suspend | N/A | *bool 型、printBoolPtr で変換 |
| `status.active` | Active | N/A | ObjectReference 配列の len() |
| `status.lastScheduleTime` | Last Schedule | N/A | nil なら "<none>" |
| `spec.jobTemplate.spec.template.spec.containers` | Containers, Images (wide) | N/A | layoutContainerCells |
| `spec.jobTemplate.spec.selector` | Selector (wide) | N/A | metav1.FormatLabelSelector |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Timezone | `obj.Spec.TimeZone != nil ? *obj.Spec.TimeZone : "<none>"` | N/A | |
| Suspend | `printBoolPtr(obj.Spec.Suspend)` | N/A | *bool を "True"/"False" に変換 |
| Active | `int64(len(obj.Status.Active))` | N/A | アクティブ Job の参照数 |
| Last Schedule | `obj.Status.LastScheduleTime != nil ? translateTimestampSince(*LastScheduleTime) : "<none>"` | N/A | |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get cronjobs 実行] --> B[API サーバへリクエスト]
    B --> C[CronJob リスト取得]
    C --> D[printCronJobList]
    D --> E[printCronJob で各行生成]
    E --> F[HumanReadablePrinter でテーブル出力]
    F --> G[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | CronJob が存在しない | `No resources found in {namespace} namespace.` | 条件見直し |
| API エラー | 接続失敗 | API エラーメッセージ | kubeconfig 確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数百件 |
| 目標出力時間 | 即時 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

- CronJob 一覧取得には `cronjobs` リソース（batch グループ）の `list` / `get` 権限が必要

## 備考

- Timezone カラムは Kubernetes 1.27 でデフォルト有効化された TimeZone フィールドに対応
- Suspend フラグが True の場合、新規 Job の生成が停止される
- Active はアクティブな Job オブジェクトへの参照（ObjectReference）の配列長
- Wide 出力のコンテナ情報は JobTemplate -> Template -> Spec -> Containers という深いネスト構造から取得

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | cronJobColumnDefinitions（行 184-195）: 7 通常カラム + 3 wide カラム。Timezone が独自カラムとして存在 |

**読解のコツ**: CronJob は Job と異なり Status ではなく Spec から多くのカラムを取得する。Active は Status.Active 配列の長さ。

#### Step 2: print 関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printCronJob`（行 1288-1309）: LastScheduleTime と TimeZone の nil チェック、printBoolPtr による Suspend 表示 |
| 2-2 | printers.go | `pkg/printers/internalversion/printers.go` | `printCronJobList`（行 1311-1321）: Items を順に委譲 |

**主要処理フロー**:
- **行 1293-1296**: LastScheduleTime の nil チェック、nil なら "<none>"
- **行 1298-1301**: TimeZone の nil チェック、nil なら "<none>"
- **行 1303**: Name, Schedule, TimeZone, Suspend(printBoolPtr), Active(int64(len())), LastScheduleTime, Age をセルに追加
- **行 1304-1307**: Wide 時に JobTemplate.Spec.Template.Spec.Containers からコンテナ情報、JobTemplate.Spec.Selector からセレクタを取得

### プログラム呼び出し階層図

```
kubectl get cronjobs
    |
    +-- GetOptions.Run() [get.go]
           |
           +-- API Server Request
           |       |
           |       +-- printCronJobList() [printers.go 行1311]
           |               |
           |               +-- printCronJob() [printers.go 行1288]
           |                       |
           |                       +-- printBoolPtr()
           |                       +-- translateTimestampSince()
           |                       +-- layoutContainerCells() (wide)
           |                       +-- metav1.FormatLabelSelector() (wide)
           |
           +-- HumanReadablePrinter.PrintObj()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

API Server (etcd)          printCronJob()                     標準出力 (stdout)
  CronJob Object       --> - TimeZone nil チェック           --> テーブル形式テキスト
  (batch.CronJob)          - LastScheduleTime nil チェック       NAME SCHEDULE TIMEZONE ...
                           - printBoolPtr(Suspend)               cj1  */5****  Tokyo  False ...
                           - len(Active) 計算
                           - TableRow 生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | CronJob 用カラム定義と print 関数（行 184-197, 1288-1321） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルレンダリング |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl get コマンドエントリーポイント |
