---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-Pod一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **ChunkSize デフォルト値**：コード上のデフォルト値の確認が必要
  2. **サーバサイドテーブル変換の有効バージョン**：公式ドキュメント参照推奨
  3. **RBAC 権限要件**：設計書記載の権限が正確か要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/printers/internalversion/printers.go` 行 93-108（podColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 898-1085（printPod 関数）
- E-03: `pkg/printers/internalversion/printers.go` 行 886-896（printPodList 関数）
- E-04: `pkg/printers/tablegenerator.go` 行 30-33（GenerateOptions 構造体）
- E-05: `pkg/printers/tablegenerator.go` 行 78-121（GenerateTable メソッド）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/get/table_printer.go` 行 38-47（TablePrinter.PrintObj）
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/get/table_printer.go` 行 58-94（decodeIntoTable）
- E-08: `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` 行 55-80（GetOptions 構造体）
- E-09: `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` 行 72-77（HumanReadablePrinter）
- E-10: `pkg/printers/internalversion/printers.go` 行 1046（セル追加: Name, Ready, Status, Restarts, Age）
- E-11: `pkg/printers/internalversion/printers.go` 行 1047-1082（Wide 出力カラム）
- E-12: `pkg/printers/internalversion/printers.go` 行 930-986（InitContainer 状態解析）
- E-13: `pkg/printers/internalversion/printers.go` 行 988-1033（ContainerStatuses 解析）
- E-14: `pkg/printers/internalversion/printers.go` 行 1035-1039（DeletionTimestamp 判定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pod 用カラムは Name, Ready, Status, Restarts, Age の 5 列 | E-01 | ○ |
| C-02 | Wide 出力時に IP, Node, Nominated Node, Readiness Gates が追加 | E-01, E-11 | ○ |
| C-03 | Priority=0 が通常表示、Priority=1 が wide 表示 | E-05 (行94-101) | ○ |
| C-04 | printPod は Ready 数を readyContainers/totalContainers 形式で表示 | E-10 | ○ |
| C-05 | totalContainers は Spec.Containers + restartable init containers | E-02 (行901, 933-936) | ○ |
| C-06 | Status の基本値は pod.Status.Phase | E-02 (行906-907) | ○ |
| C-07 | Status.Reason が設定されていれば Phase を上書き | E-02 (行908-910) | ○ |
| C-08 | SchedulingGated 条件のチェックが行われる | E-02 (行913-917) | ○ |
| C-09 | InitContainer の状態で Init:Signal, Init:ExitCode, Init:Reason を表示 | E-12 | ○ |
| C-10 | DeletionTimestamp 設定時に Terminating / Unknown を表示 | E-14 | ○ |
| C-11 | Restarts は ContainerStatuses と restartable InitContainerStatuses の合計 | E-02 (行989-1002) | ○ |
| C-12 | 再起動回数が 0 でない場合、最終再起動時刻からの経過時間を表示 | E-02 (行1041-1044) | ○ |
| C-13 | Wide 出力で PodIP 未割当時は `<none>` と表示 | E-11 (行1055-1057) | ○ |
| C-14 | Wide 出力で NodeName 未配置時は `<none>` と表示 | E-11 (行1058-1060) | ○ |
| C-15 | Wide 出力で Readiness Gates は true/total 形式 | E-11 (行1066-1080) | ○ |
| C-16 | printPodList は Items を順に printPod に委譲 | E-03 | ○ |
| C-17 | TablePrinter がサーバレスポンスのデコードを試行しフォールバック | E-06, E-07 | ○ |
| C-18 | HumanReadableGenerator は reflect を使った型ベースのハンドラマップ | E-05 | ○ |
| C-19 | GenerateOptions.Wide でカラム数が変わる | E-04, E-05 | ○ |
| C-20 | tabwriter によるカラム整列が行われる | E-09 | ○ |
| C-21 | Completed 状態で Running コンテナがある場合 Running に変更 | E-13 (行1024-1032) | ○ |
| C-22 | Pod の Phase が Succeeded なら podSuccessConditions を設定 | E-02 (行923-928) | ○ |
| C-23 | Age は translateTimestampSince で人間可読形式に変換 | E-02 (行1046), E-02 (行863) | ○ |
| C-24 | hasPodReadyCondition は PodReady && ConditionTrue を確認 | E-02 (行1087-1094) | ○ |
| C-25 | ChunkSize デフォルト値は 500 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ChunkSize のデフォルト値（500）は get.go 内の初期値を別途確認する必要がある
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` / `staging/src/k8s.io/kubectl/pkg/cmd/get/get_flags.go` / kubectl ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: Status 算出ロジックの記述は printPod 関数のコードに忠実であり低リスク
- 0: カラム定義は AddHandlers 内の podColumnDefinitions に完全一致しており低リスク
- 1: ChunkSize デフォルト値は別ファイルで定義されており中リスク（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] podColumnDefinitions の 9 カラムが設計書と一致しているか確認
- [ ] printPod の Status 算出ロジック（Init/Container/DeletionTimestamp）が正確に記述されているか確認
- [ ] Wide 出力の追加カラム（IP, Node, Nominated Node, Readiness Gates）の仕様が正しいか確認
- [ ] ChunkSize のデフォルト値を get.go / get_flags.go で確認
