---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Ingress一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  1. 優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行 212-219（ingressColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 220-221（TableHandler 登録）
- E-03: `pkg/printers/internalversion/printers.go` 行 1452-1466（printIngress 関数）
- E-04: `pkg/printers/internalversion/printers.go` 行 1488-1498（printIngressList 関数）
- E-05: `pkg/printers/internalversion/printers.go` 行 1423-1443（formatHosts 関数）
- E-06: `pkg/printers/internalversion/printers.go` 行 1445-1450（formatPorts 関数）
- E-07: `pkg/printers/internalversion/printers.go` 行 1468-1486（ingressLoadBalancerStatusStringer 関数）
- E-08: `pkg/printers/internalversion/printers.go` 行 82（loadBalancerWidth 定数 = 16）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ingress のカラムは Name, Class, Hosts, Address, Ports, Age の 6 列 | E-01 | ○ |
| C-02 | 全カラムが Priority=0 で Wide 追加カラムなし | E-01 | ○ |
| C-03 | Class は Spec.IngressClassName、nil なら "<none>" | E-03 (行1456-1459) | ○ |
| C-04 | Hosts は formatHosts(Spec.Rules) で生成 | E-03 (行1460) | ○ |
| C-05 | formatHosts は最大 3 件のホスト名を表示 | E-05 (行1425) | ○ |
| C-06 | 3 件超過時は "+ N more..." と表示 | E-05 (行1440) | ○ |
| C-07 | ホストが 0 件なら "*" を表示 | E-05 (行1436) | ○ |
| C-08 | Address は ingressLoadBalancerStatusStringer で生成 | E-03 (行1461) | ○ |
| C-09 | LB ステータスから IP と Hostname を取得 | E-07 (行1473-1479) | ○ |
| C-10 | IP/Hostname は sets.NewString で重複排除しソート | E-07 (行1472, 1481) | ○ |
| C-11 | 非 wide 時は 16 文字で切り詰め | E-07 (行1482-1484), E-08 | ○ |
| C-12 | Ports は formatPorts で生成 | E-03 (行1462) | ○ |
| C-13 | TLS 設定ありなら "80, 443" | E-06 (行1447) | ○ |
| C-14 | TLS 設定なしなら "80" | E-06 (行1449) | ○ |
| C-15 | Name, Class, Hosts, Address, Ports, Age をセルに追加 | E-03 (行1464) | ○ |
| C-16 | printIngressList は Items を順に委譲 | E-04 | ○ |
| C-17 | Name カラムは Format: "name" | E-01 (行213) | ○ |
| C-18 | printIngress と printIngressList が登録 | E-02 | ○ |
| C-19 | Host が空文字列のルールはスキップ | E-05 (行1431) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: Ingress の print 関数はヘルパー関数への委譲が中心で低リスク
- 0: formatHosts / formatPorts / ingressLoadBalancerStatusStringer は自己完結型で低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ingressColumnDefinitions の 6 カラムが設計書と一致しているか確認
- [ ] formatHosts の最大 3 件制限と "+ N more..." 表示が正しいか確認
- [ ] formatPorts の TLS 判定ロジック（あり: "80, 443"、なし: "80"）が正しいか確認
- [ ] ingressLoadBalancerStatusStringer の切り詰めロジック（16 文字）が正しいか確認
