---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：11-IngressClass一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数「1〜10件程度」**：根拠不足（経験的見積もり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/printers/internalversion/printers.go` 行223-230（ingressClassColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行1500-1520（printIngressClass関数）
- E-03: `pkg/printers/internalversion/printers.go` 行93（AddHandlers関数）
- E-04: `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` 行72-77（HumanReadablePrinter構造体）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行12（IngressClass一覧の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Controller, Parameters, Ageの4つ | E-01 | ○ |
| C-02 | デフォルトIngressClassには「(default)」が付与される | E-02 (行1506-1508) | ○ |
| C-03 | Parametersがnilの場合は`<none>`と表示される | E-02 (行1509) | ○ |
| C-04 | Parameters形式はKind.APIGroup/Nameである | E-02 (行1510-1516) | ○ |
| C-05 | APIGroupがnilの場合は「.APIGroup」部分を省略する | E-02 (行1512-1513) | ○ |
| C-06 | AGEはtranslateTimestampSinceで相対時間に変換される | E-02 (行1517) | ○ |
| C-07 | printIngressClassListはリスト内の各アイテムに対してprintIngressClassを呼び出す | E-02 (行1522-1531) | ○ |
| C-08 | TableHandlerに登録される印刷関数はprintIngressClassとprintIngressClassList | E-01 (行229-230) | ○ |
| C-09 | Wide出力時に追加カラムは表示されない | E-01, E-02 | ○ |
| C-10 | クラスタスコープリソースでありNamespace不要 | E-05 | ○ |
| C-11 | kubectl get ingressclassコマンドで使用される | E-05 | ○ |
| C-12 | 想定データ件数は1〜10件程度 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数「1〜10件程度」の根拠がない
  - 候補：実運用環境の統計データ / ベンチマークテスト結果 / 公式ドキュメントの推奨値

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義と出力ロジックはソースコードから直接確認済み
- 0: 低リスク - デフォルト判定ロジックもソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, Controller, Parameters, Age）がソースコードと一致するか確認
- [ ] デフォルトIngressClassの判定ロジックが正確に記載されているか確認
- [ ] Parameters表示形式の説明が実装と一致するか確認
