---
generated_at: 2026-02-02 10:01:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：12-StatefulSet一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数「数件〜数百件」**：根拠不足（経験的見積もり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行232-240（statefulSetColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行1534-1547（printStatefulSet関数）
- E-03: `pkg/printers/internalversion/printers.go` 行93（AddHandlers関数）
- E-04: `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go`（HumanReadablePrinter）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行13（StatefulSet一覧の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通常カラムはName, Ready, Ageの3つ | E-01 | ○ |
| C-02 | Wide時にContainers, Imagesが追加される | E-01 (Priority:1), E-02 (行1542-1544) | ○ |
| C-03 | READYはreadyReplicas/desiredReplicas形式 | E-02 (行1541) | ○ |
| C-04 | desiredReplicasはobj.Spec.Replicasから取得 | E-02 (行1538) | ○ |
| C-05 | readyReplicasはobj.Status.ReadyReplicasから取得 | E-02 (行1539) | ○ |
| C-06 | AGEはtranslateTimestampSinceで変換 | E-02 (行1540) | ○ |
| C-07 | Wide時のコンテナ情報はlayoutContainerCells関数で整形 | E-02 (行1543) | ○ |
| C-08 | StatefulSetはNamespaceスコープリソース | E-05 | ○ |
| C-09 | kubectl get stsは省略形 | E-05 | ○ |
| C-10 | printStatefulSetListはリスト各アイテムにprintStatefulSetを呼び出す | E-02 (行1549-1558) | ○ |
| C-11 | 想定データ件数は数件〜数百件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数の根拠がない
  - 候補：実運用環境の統計データ / クラスタ規模の標準的な指標

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義と出力ロジックはソースコードから直接確認済み
- 0: 低リスク - READYの計算式はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, Ready, Age + Wide: Containers, Images）がソースコードと一致するか確認
- [ ] READY表示形式（readyReplicas/desiredReplicas）が正確か確認
- [ ] Wide出力時のコンテナ情報表示が正確か確認
