---
generated_at: 2026-02-02 10:02:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：13-Endpoints一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数「数件〜数百件」**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行242-248（endpointColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行1592-1598（printEndpoints関数）
- E-03: `pkg/printers/internalversion/printers.go` 行749-798（formatEndpoints関数）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行14（Endpoints一覧の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Endpoints, Ageの3つ | E-01 | ○ |
| C-02 | ENDPOINTSカラムはformatEndpoints関数で生成される | E-02 (行1596) | ○ |
| C-03 | Subsetsが空の場合`<none>`を返す | E-03 (行750-751) | ○ |
| C-04 | 最大表示件数は3件 | E-03 (行754) | ○ |
| C-05 | 3件超過時は「+ N more...」形式で表示 | E-03 (行793-796) | ○ |
| C-06 | ポートなしの場合はIPのみ表示 | E-03 (行759-771) | ○ |
| C-07 | ポートありの場合はnet.JoinHostPortでIP:Port形式 | E-03 (行786) | ○ |
| C-08 | AGEはtranslateTimestampSinceで変換 | E-02 (行1596) | ○ |
| C-09 | EndpointsはNamespaceスコープリソース | E-04 | ○ |
| C-10 | kubectl get epは省略形 | E-04 | ○ |
| C-11 | Wide出力時に追加カラムは表示されない | E-01 | ○ |
| C-12 | 想定データ件数は数件〜数百件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数の根拠がない
  - 候補：実運用環境の統計データ / Service数に相関

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義と出力ロジックはソースコードから直接確認済み
- 0: 低リスク - formatEndpoints関数のロジックは詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, Endpoints, Age）がソースコードと一致するか確認
- [ ] formatEndpoints関数の最大表示件数（3件）と省略表示形式が正確か確認
- [ ] ヘッドレスService時の表示が正確に記載されているか確認
