---
generated_at: 2026-02-02 10:03:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-Node一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数「数件〜数千件」**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行250-264（nodeColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行1952-2004（printNode関数）
- E-03: `pkg/printers/internalversion/printers.go` 行2033-2047（findNodeRoles関数）
- E-04: `pkg/printers/internalversion/printers.go` 行2007-2027（getNodeExternalIP/getNodeInternalIP関数）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行15（Node一覧の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通常カラムはName, Status, Roles, Age, Versionの5つ | E-01 | ○ |
| C-02 | Wide時にInternal-IP, External-IP, OS-Image, Kernel-Version, Container-Runtimeが追加 | E-01 (Priority:1), E-02 (行1986-2001) | ○ |
| C-03 | StatusはNodeReady Conditionから判定 | E-02 (行1957-1972) | ○ |
| C-04 | Conditionsが空の場合は「Unknown」 | E-02 (行1973-1974) | ○ |
| C-05 | Unschedulableがtrueなら「SchedulingDisabled」追加 | E-02 (行1976-1978) | ○ |
| C-06 | ロールはnode-role.kubernetes.io/*ラベルから判定 | E-03 (行2037-2039) | ○ |
| C-07 | kubernetes.io/roleラベルからもロール判定可能 | E-03 (行2042-2043) | ○ |
| C-08 | ロール未設定時は`<none>` | E-02 (行1981-1983) | ○ |
| C-09 | Internal-IPはNodeInternalIP型から取得、未設定時`<none>` | E-04 (行2018-2027) | ○ |
| C-10 | External-IPはNodeExternalIP型から取得、未設定時`<none>` | E-04 (行2007-2016) | ○ |
| C-11 | OSImageが空文字の場合`<unknown>` | E-02 (行1988-1990) | ○ |
| C-12 | KernelVersionが空文字の場合`<unknown>` | E-02 (行1991-1993) | ○ |
| C-13 | KernelVersionにArchitectureが括弧付きで付加される | E-02 (行1998-2000) | ○ |
| C-14 | ContainerRuntimeVersionが空文字の場合`<unknown>` | E-02 (行1994-1996) | ○ |
| C-15 | Nodeはクラスタスコープリソース | E-05 | ○ |
| C-16 | 想定データ件数は数件〜数千件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数の根拠がない
  - 候補：Kubernetes公式ドキュメントのクラスタ規模上限 / 実運用環境の統計

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義と出力ロジックはソースコードから詳細に確認済み
- 0: 低リスク - ステータス判定ロジックも詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] STATUS生成ロジック（Condition解析 + SchedulingDisabled）が正確か確認
- [ ] ROLES判定ロジック（2つのラベルパターン）が正確か確認
- [ ] Wide出力時の各カラムのデフォルト値（`<none>`, `<unknown>`）が正確か確認
