---
generated_at: 2026-02-02 10:04:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：15-Event一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数「数十件〜数万件」**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行266-279（eventColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行2158-2212（printEvent関数）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行16（Event一覧の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通常カラムはLast Seen, Type, Reason, Object, Messageの5つ | E-01, E-02 (行2201-2208) | ○ |
| C-02 | Wide時にSubobject, Source, First Seen, Count, Nameが追加 | E-01 (Priority:1), E-02 (行2188-2200) | ○ |
| C-03 | LastTimestampがゼロならFirstTimestampを使用 | E-02 (行2168-2171) | ○ |
| C-04 | FirstTimestampがゼロならEventTimeを使用 | E-02 (行2163-2166) | ○ |
| C-05 | SeriesがあればSeries.LastObservedTimeとSeries.Countを優先 | E-02 (行2174-2176) | ○ |
| C-06 | Singletonイベント(count==0)の場合はcount=1に補正 | E-02 (行2177-2180) | ○ |
| C-07 | OBJECTはkind/name形式（小文字） | E-02 (行2182-2187) | ○ |
| C-08 | InvolvedObject.Nameが空の場合kindのみ | E-02 (行2186) | ○ |
| C-09 | Messageは前後の空白がトリムされる | E-02 (行2196, 2207) | ○ |
| C-10 | SOURCEはformatEventSource関数で整形 | E-02 (行2195) | ○ |
| C-11 | SUBOBJECTはInvolvedObject.FieldPath | E-02 (行2194) | ○ |
| C-12 | NAMEはobj.Name | E-02 (行2199) | ○ |
| C-13 | EventはNamespaceスコープリソース | E-03 | ○ |
| C-14 | 通常モードは5カラム、Wideは10カラム | E-01, E-02 | ○ |
| C-15 | 想定データ件数は数十件〜数万件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数の根拠がない
  - 候補：EventのTTL設定 / 実運用環境の統計 / etcdストレージの推奨上限

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義と出力ロジックはソースコードから詳細に確認済み
- 1: 中リスク - タイムスタンプのフォールバックロジックが複雑で、誤解しやすい

## 6) レビュアーチェックリスト（最小）
- [ ] タイムスタンプのフォールバック順序（LastTimestamp -> FirstTimestamp -> EventTime, Series優先）が正確か確認
- [ ] Singletonイベントのcount=1補正が正確に記載されているか確認
- [ ] Wide/通常モードのカラム差異が正確か確認
