---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 9
  claims_with_evidence: 8
  claims_without_evidence: 1
confidence_derived: 0.89
---

# 根拠レポート：16-Namespace一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：8 / 9、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数「数件〜数百件」**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行281-287（namespaceColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行1892-1898（printNamespace関数）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行17（Namespace一覧の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Status, Ageの3つ | E-01 | ○ |
| C-02 | STATUSはobj.Status.Phaseを文字列変換 | E-02 (行1896) | ○ |
| C-03 | AGEはtranslateTimestampSinceで変換 | E-02 (行1896) | ○ |
| C-04 | Namespaceはクラスタスコープリソース | E-03 | ○ |
| C-05 | kubectl get nsは省略形 | E-03 | ○ |
| C-06 | Wide出力時に追加カラムは表示されない | E-01 | ○ |
| C-07 | NamespacePhaseはActive/Terminatingの2値 | E-02 | ○ |
| C-08 | printNamespace関数は非常にシンプル（1行で3カラム出力） | E-02 (行1896) | ○ |
| C-09 | 想定データ件数は数件〜数百件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数の根拠がない
  - 候補：Kubernetes公式ドキュメントのNamespace数上限 / 実運用環境の統計

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルな実装であり誤りの可能性が低い

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, Status, Age）がソースコードと一致するか確認
- [ ] STATUS表示がPhaseの文字列変換であることを確認
