---
generated_at: 2026-02-02 10:08:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：19-PersistentVolume一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数「数件〜数千件」**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行305-319（persistentVolumeColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行2061-2097（printPersistentVolume関数）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行20（PersistentVolume一覧の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通常カラムは10個（Name, Capacity, Access Modes, Reclaim Policy, Status, Claim, StorageClass, VolumeAttributesClass, Reason, Age） | E-01 | ○ |
| C-02 | Wide時にVOLUMEMODEカラムが追加 | E-01 (Priority:1) | ○ |
| C-03 | ClaimRefからnamespace/name形式でCLAIM文字列を生成 | E-02 (行2066-2071) | ○ |
| C-04 | ClaimRefがnilの場合はCLAIMが空文字 | E-02 (行2066) | ○ |
| C-05 | AccessModesはhelper.GetAccessModesAsStringで変換 | E-02 (行2073) | ○ |
| C-06 | ReclaimPolicyはPersistentVolumeReclaimPolicyをstring変換 | E-02 (行2074) | ○ |
| C-07 | Capacityはspec.Capacity[ResourceStorage]のQuantity文字列 | E-02 (行2076-2077) | ○ |
| C-08 | DeletionTimestampが非nilなら「Terminating」に上書き | E-02 (行2080-2082) | ○ |
| C-09 | VolumeModeがnilなら`<unset>` | E-02 (行2083-2086) | ○ |
| C-10 | VolumeAttributesClassNameがnilなら`<unset>` | E-02 (行2088-2091) | ○ |
| C-11 | StorageClassはhelper.GetPersistentVolumeClassで取得 | E-02 (行2094) | ○ |
| C-12 | Reasonはobj.Status.Reason | E-02 (行2095) | ○ |
| C-13 | PVはクラスタスコープリソース | E-03 | ○ |
| C-14 | kubectl get pvは省略形 | E-03 | ○ |
| C-15 | 想定データ件数は数件〜数千件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数の根拠がない
  - 候補：ストレージプロビジョニングの規模 / 実運用環境の統計

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義と出力ロジックはソースコードから詳細に確認済み
- 0: 低リスク - DeletionTimestampによるTerminating判定もソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 全11カラム（通常10 + Wide1）の定義がソースコードと一致するか確認
- [ ] CLAIM文字列のnamespace/name形式が正確か確認
- [ ] Terminating判定（DeletionTimestamp）が正確に記載されているか確認
- [ ] `<unset>`デフォルト値の適用条件が正確か確認
