---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-PodTemplate一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 優先レビュー項目なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行 110-115（podTemplateColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 116-117（TableHandler 登録）
- E-03: `pkg/printers/internalversion/printers.go` 行 1105-1112（printPodTemplate 関数）
- E-04: `pkg/printers/internalversion/printers.go` 行 1114-1124（printPodTemplateList 関数）
- E-05: `pkg/printers/internalversion/printers.go` 行 2767（layoutContainerCells 関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PodTemplate のカラムは Name, Containers, Images, Pod Labels の 4 列 | E-01 | ○ |
| C-02 | 全カラムが Priority=0 で Wide 追加カラムなし | E-01 | ○ |
| C-03 | Name は obj.Name から取得 | E-03 (行1110) | ○ |
| C-04 | Containers は layoutContainerCells で生成 | E-03 (行1109) | ○ |
| C-05 | Images は layoutContainerCells で生成 | E-03 (行1109) | ○ |
| C-06 | Pod Labels は labels.FormatLabels で生成 | E-03 (行1110) | ○ |
| C-07 | printPodTemplateList は Items を順に printPodTemplate に委譲 | E-04 | ○ |
| C-08 | layoutContainerCells はコンテナ名とイメージ名を返す | E-05 | ○ |
| C-09 | データは Template.Spec.Containers から取得 | E-03 (行1109) | ○ |
| C-10 | ラベルは Template.Labels から取得 | E-03 (行1110) | ○ |
| C-11 | printPodTemplate と printPodTemplateList が TableHandler に登録 | E-02 | ○ |
| C-12 | Name カラムは Format: "name" を持つ | E-01 (行111) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: PodTemplate の print 関数は非常にシンプルで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] podTemplateColumnDefinitions の 4 カラムが設計書と一致しているか確認
- [ ] printPodTemplate 関数のセル追加順序（Name, Containers, Images, Pod Labels）が正しいか確認
