---
generated_at: 2026-02-02 10:09:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：20-PersistentVolumeClaim一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数「数件〜数百件」**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行321-333（persistentVolumeClaimColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行2111-2144（printPersistentVolumeClaim関数）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行21（PersistentVolumeClaim一覧の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通常カラムは8個（Name, Status, Volume, Capacity, Access Modes, StorageClass, VolumeAttributesClass, Age） | E-01 | ○ |
| C-02 | Wide時にVOLUMEMODEカラムが追加 | E-01 (Priority:1) | ○ |
| C-03 | DeletionTimestampが非nilなら「Terminating」に上書き | E-02 (行2116-2119) | ○ |
| C-04 | VolumeNameが設定されている場合のみCapacityとAccessModesが表示される | E-02 (行2131-2135) | ○ |
| C-05 | VolumeNameが空の場合、CapacityとAccessModesは空文字 | E-02 (行2123-2125) | ○ |
| C-06 | CAPACITYはStatus.Capacity（Spec.Requestsではない） | E-02 (行2133) | ○ |
| C-07 | ACCESS MODESはStatus.AccessModes | E-02 (行2132) | ○ |
| C-08 | VolumeAttributesClassNameがnilなら`<unset>` | E-02 (行2121, 2127-2129) | ○ |
| C-09 | VolumeModeがnilなら`<unset>` | E-02 (行2125, 2137-2139) | ○ |
| C-10 | StorageClassはhelper.GetPersistentVolumeClaimClassで取得 | E-02 (行2142) | ○ |
| C-11 | VOLUMEはobj.Spec.VolumeName | E-02 (行2141) | ○ |
| C-12 | PVCはNamespaceスコープリソース | E-03 | ○ |
| C-13 | kubectl get pvcは省略形 | E-03 | ○ |
| C-14 | 想定データ件数は数件〜数百件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数の根拠がない
  - 候補：実運用環境の統計 / Namespace内の一般的なPVC数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義と出力ロジックはソースコードから詳細に確認済み
- 1: 中リスク - CAPACITYがSpec.RequestsではなくStatus.Capacityであることの明記が重要

## 6) レビュアーチェックリスト（最小）
- [ ] 全9カラム（通常8 + Wide1）の定義がソースコードと一致するか確認
- [ ] CapacityがStatus.Capacity（実際の割り当て容量）であることを確認
- [ ] VolumeNameが空の場合のCapacity/AccessModesの挙動が正確か確認
- [ ] Terminating判定（DeletionTimestamp）が正確に記載されているか確認
