---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：21-ComponentStatus一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **非推奨ステータスの詳細**：公式ドキュメントでの非推奨の具体的バージョンの確認が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/printers/internalversion/printers.go` L335-342（カラム定義）
- E-02: `pkg/printers/internalversion/printers.go` L2402-2423（printComponentStatus関数）
- E-03: `pkg/printers/internalversion/printers.go` L2425-2435（printComponentStatusList関数）
- E-04: `pkg/printers/internalversion/printers_test.go` L5519（テストケース）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` L22（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Status, Message, Errorの4つ | E-01 | ○ |
| C-02 | kubectl get csで使用される | E-05 | ○ |
| C-03 | StatusはHealthy/Unhealthy/Unknownの3値 | E-02 | ○ |
| C-04 | ComponentHealthy条件のStatusがTrueならHealthy | E-02 (L2410-2414) | ○ |
| C-05 | 初期値はstatus="Unknown", message="", error="" | E-02 (L2406-2408) | ○ |
| C-06 | Conditions配列の最初のComponentHealthy条件でbreak | E-02 (L2418) | ○ |
| C-07 | printComponentStatusListは各アイテムに対してprintComponentStatusを呼出 | E-03 | ○ |
| C-08 | テストケースが存在する | E-04 | ○ |
| C-09 | 非推奨APIである | E-05（備考欄に記載） | ○ |
| C-10 | Wideオプション対応カラムなし | E-01, E-02 | ○ |
| C-11 | クラスタスコープリソースである | E-02 | ○ |
| C-12 | 代替手段としてヘルスチェックエンドポイント直接アクセスが推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12の代替手段に関する記述はコードベースからは確認できない。Kubernetes公式ドキュメントの参照が必要。
  - 候補：Kubernetes公式ドキュメント / KEP / リリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義と出力ロジックはコードから直接確認可能
- 1: 中リスク - 非推奨APIの代替手段に関する記述は外部情報源に依存

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, Status, Message, Error）がソースコードと一致しているか確認
- [ ] ステータス判定ロジック（Healthy/Unhealthy/Unknown）が正しく記載されているか確認
- [ ] 非推奨APIとしての注意書きが適切か確認
