---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-Deployment一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` L344-355（カラム定義とハンドラ登録）
- E-02: `pkg/printers/internalversion/printers.go` L2437-2460（printDeployment関数）
- E-03: `pkg/printers/internalversion/printers.go` L2462-2472（printDeploymentList関数）
- E-04: `pkg/printers/internalversion/printers_test.go` L2633（テストケース）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` L23（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 標準カラムはName, Ready, Up-to-date, Available, Ageの5つ | E-01 | ○ |
| C-02 | WideカラムはContainers, Images, Selectorの3つ | E-01 (Priority:1) | ○ |
| C-03 | Ready列は"{readyReplicas}/{desiredReplicas}"形式 | E-02 (L2454) | ○ |
| C-04 | desiredReplicasはSpec.Replicasから取得 | E-02 (L2441) | ○ |
| C-05 | updatedReplicasはStatus.UpdatedReplicasから取得 | E-02 (L2442) | ○ |
| C-06 | readyReplicasはStatus.ReadyReplicasから取得 | E-02 (L2443) | ○ |
| C-07 | availableReplicasはStatus.AvailableReplicasから取得 | E-02 (L2444) | ○ |
| C-08 | AgeはCreationTimestampからtranslateTimestampSinceで変換 | E-02 (L2445) | ○ |
| C-09 | SelectorはLabelSelectorAsSelectorで文字列化 | E-02 (L2447) | ○ |
| C-10 | Selectorの解析失敗時は"<invalid>"を表示 | E-02 (L2450) | ○ |
| C-11 | Wide時にlayoutContainerCellsでContainers/Imagesを整形 | E-02 (L2456) | ○ |
| C-12 | printDeploymentListは各アイテムに対してprintDeploymentを呼出 | E-03 | ○ |
| C-13 | kubectl get deploymentsで使用 | E-05 | ○ |
| C-14 | テストケースが存在する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（5標準+3Wide）がソースコードと一致しているか確認
- [ ] Ready列のフォーマット形式が正しいか確認
- [ ] Wideモードでの追加カラム処理が正しく記載されているか確認
