---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-HorizontalPodAutoscaler一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` L357-367（カラム定義）
- E-02: `pkg/printers/internalversion/printers.go` L2575-2592（printHorizontalPodAutoscaler関数）
- E-03: `pkg/printers/internalversion/printers.go` L2474-2573（formatHPAMetrics関数）
- E-04: `pkg/printers/internalversion/printers_test.go` L3200（テストケース）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` L24（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Reference, Targets, MinPods, MaxPods, Replicas, Ageの7つ | E-01 | ○ |
| C-02 | ReferenceはKind/Name形式 | E-02 (L2580-2582) | ○ |
| C-03 | MinPodsがnilの場合"<unset>"を表示 | E-02 (L2583-2587) | ○ |
| C-04 | MaxPodsはSpec.MaxReplicasから取得 | E-02 (L2588) | ○ |
| C-05 | ReplicasはStatus.CurrentReplicasから取得 | E-02 (L2589) | ○ |
| C-06 | メトリクスが0件の場合"<none>"を表示 | E-03 (L2475-2477) | ○ |
| C-07 | メトリクス表示は最大2つまで | E-03 (L2479) | ○ |
| C-08 | 3つ以上のメトリクスは"+ N more..."で省略 | E-03 (L2569-2571) | ○ |
| C-09 | External(AverageValue)タイプのフォーマット | E-03 (L2485-2490) | ○ |
| C-10 | Resource(AverageUtilization)タイプのフォーマット | E-03 (L2525-2536) | ○ |
| C-11 | 現在値不明時は"<unknown>"表示 | E-03 (L2486, L2492等) | ○ |
| C-12 | ContainerResourceメトリクスタイプ対応 | E-03 (L2537-2555) | ○ |
| C-13 | Podsメトリクスタイプ対応 | E-03 (L2498-2503) | ○ |
| C-14 | Objectメトリクスタイプ対応 | E-03 (L2504-2517) | ○ |
| C-15 | kubectl get hpaで使用 | E-05 | ○ |
| C-16 | テストケースが存在する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（7カラム）がソースコードと一致しているか確認
- [ ] formatHPAMetricsの各メトリクスタイプのフォーマットが正しいか確認
- [ ] メトリクス表示上限（2つ）と省略表記が正しく記載されているか確認
