---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-CertificateSigningRequest一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` L407-416（カラム定義）
- E-02: `pkg/printers/internalversion/printers.go` L2281-2296（printCertificateSigningRequest関数）
- E-03: `pkg/printers/internalversion/printers.go` L2298-2326（extractCSRStatus関数）
- E-04: `pkg/printers/internalversion/printers.go` L2328-2338（printCertificateSigningRequestList関数）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` L29（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Age, SignerName, Requestor, RequestedDuration, Conditionの6つ | E-01 | ○ |
| C-02 | ConditionはextractCSRStatusで判定 | E-02 (L2285), E-03 | ○ |
| C-03 | SignerNameが空の場合"<none>"表示 | E-02 (L2286-2289) | ○ |
| C-04 | ExpirationSecondsがnilの場合"<none>"表示 | E-02 (L2290-2293) | ○ |
| C-05 | ExpirationSecondsが存在する場合HumanDurationで変換 | E-02 (L2292) | ○ |
| C-06 | RequestorはSpec.Usernameから取得 | E-02 (L2294) | ○ |
| C-07 | DeniedがApprovedより優先される | E-03 (L2312-2317) | ○ |
| C-08 | Denied/Approved/Pendingは相互排他 | E-03 (L2312-2318) | ○ |
| C-09 | FailedはConditionに",Failed"として付加 | E-03 (L2319-2321) | ○ |
| C-10 | Certificate存在時は",Issued"が付加 | E-03 (L2322-2324) | ○ |
| C-11 | Conditionsの走査でApproved/Denied/Failedフラグを設定 | E-03 (L2300-2309) | ○ |
| C-12 | クラスタスコープリソースである | E-05 | ○ |
| C-13 | kubectl get csrで使用 | E-05 | ○ |
| C-14 | Wideモード固有のカラムなし | E-01, E-02 | ○ |
| C-15 | certificates.k8s.io APIグループに属する | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（6カラム）がソースコードと一致しているか確認
- [ ] extractCSRStatusのCondition判定ロジック（優先順位）が正しいか確認
- [ ] RequestedDurationのHumanDuration変換が正しく記載されているか確認
