---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-ClusterTrustBundle一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` L418-423（カラム定義）
- E-02: `pkg/printers/internalversion/printers.go` L2340-2350（printClusterTrustBundle関数）
- E-03: `pkg/printers/internalversion/printers.go` L2352-2362（printClusterTrustBundleList関数）
- E-04: `pkg/printers/internalversion/printers_test.go` L7053（テストケース）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` L30（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, SignerNameの2つ | E-01 | ○ |
| C-02 | SignerNameが空の場合"<none>"表示 | E-02 (L2344-2347) | ○ |
| C-03 | Ageカラムが存在しない | E-01 | ○ |
| C-04 | Wideモード固有のカラムなし | E-01, E-02 | ○ |
| C-05 | printClusterTrustBundleListは各アイテムに対してprintClusterTrustBundleを呼出 | E-03 | ○ |
| C-06 | certificates.k8s.io APIグループに属する | E-05 | ○ |
| C-07 | kubectl get clustertrustbundlesで使用 | E-05 | ○ |
| C-08 | テストケースが存在する | E-04 | ○ |
| C-09 | クラスタスコープリソースである | E-05 | ○ |
| C-10 | SignerNameはSpec.SignerNameから取得 | E-02 (L2345-2347) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能。非常にシンプルな出力ロジック。

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, SignerName）がソースコードと一致しているか確認
- [ ] Ageカラムがないことが仕様として正しいか確認
