---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-PodDisruptionBudget一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. 優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行 119-125（podDisruptionBudgetColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 126-127（TableHandler 登録）
- E-03: `pkg/printers/internalversion/printers.go` 行 1126-1147（printPodDisruptionBudget 関数）
- E-04: `pkg/printers/internalversion/printers.go` 行 1149-1159（printPodDisruptionBudgetList 関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PDB のカラムは Name, Min Available, Max Unavailable, Allowed Disruptions, Age の 5 列 | E-01 | ○ |
| C-02 | MinAvailable が nil の場合 "N/A" を表示 | E-03 (行1133-1137) | ○ |
| C-03 | MaxUnavailable が nil の場合 "N/A" を表示 | E-03 (行1139-1143) | ○ |
| C-04 | MinAvailable は IntOrString.String() で文字列化 | E-03 (行1134) | ○ |
| C-05 | MaxUnavailable は IntOrString.String() で文字列化 | E-03 (行1140) | ○ |
| C-06 | Allowed Disruptions は int64 にキャスト | E-03 (行1145) | ○ |
| C-07 | Age は translateTimestampSince で変換 | E-03 (行1145) | ○ |
| C-08 | Name は obj.Name から取得 | E-03 (行1145) | ○ |
| C-09 | printPodDisruptionBudgetList は Items を順に委譲 | E-04 | ○ |
| C-10 | Wide 出力に追加カラムなし | E-01 | ○ |
| C-11 | Name カラムは Format: "name" を持つ | E-01 (行120) | ○ |
| C-12 | Allowed Disruptions カラムの Type は "integer" | E-01 (行123) | ○ |
| C-13 | printPodDisruptionBudget と printPodDisruptionBudgetList が登録 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: PDB の print 関数はシンプルで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] podDisruptionBudgetColumnDefinitions の 5 カラムが設計書と一致しているか確認
- [ ] MinAvailable / MaxUnavailable の nil チェック挙動が正しく記述されているか確認
