---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-PodCertificateRequest一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` L425-435（カラム定義）
- E-02: `pkg/printers/internalversion/printers.go` L2364-2388（printPodCertificateRequest関数）
- E-03: `pkg/printers/internalversion/printers.go` L2390-2400（printPodCertificateRequestList関数）
- E-04: `pkg/printers/internalversion/printers_test.go` L7090（テストケース）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` L31（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 標準カラムはName, PodName, ServiceAccountName, NodeName, SignerName, Stateの6つ | E-01 | ○ |
| C-02 | WideカラムはUnverifiedUserAnnotationsの1つ | E-01 | ○ |
| C-03 | State初期値は"Pending" | E-02 (L2371) | ○ |
| C-04 | Issued条件で"Issued"に設定 | E-02 (L2374-2375) | ○ |
| C-05 | Denied条件で"Denied"に設定 | E-02 (L2376-2377) | ○ |
| C-06 | Failed条件で"Failed"に設定 | E-02 (L2378-2379) | ○ |
| C-07 | PodNameはSpec.PodNameから取得 | E-02 (L2383) | ○ |
| C-08 | ServiceAccountNameはSpec.ServiceAccountNameから取得 | E-02 (L2383) | ○ |
| C-09 | NodeNameはSpec.NodeNameから取得（string変換） | E-02 (L2383) | ○ |
| C-10 | Wide時にlabels.FormatLabelsでUnverifiedUserAnnotationsを文字列化 | E-02 (L2385) | ○ |
| C-11 | printPodCertificateRequestListは各アイテムに対してprintPodCertificateRequestを呼出 | E-03 | ○ |
| C-12 | certificates.k8s.io APIグループに属する | E-05 | ○ |
| C-13 | テストケースが存在する | E-04 | ○ |
| C-14 | Ageカラムが存在しない | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（6標準+1Wide）がソースコードと一致しているか確認
- [ ] State判定ロジック（Pending/Issued/Denied/Failed）が正しいか確認
- [ ] CSRのConditionとの違い（相互排他 vs 複合状態）が正しく記載されているか確認
