---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：31-Lease一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/printers/internalversion/printers.go` 437-443行目（カラム定義とハンドラ登録）
- E-02: `pkg/printers/internalversion/printers.go` 2711-2722行目（printLease関数）
- E-03: `pkg/printers/internalversion/printers.go` 2724-2734行目（printLeaseList関数）
- E-04: `pkg/printers/internalversion/printers.go` 863-869行目（translateTimestampSince関数）
- E-05: `pkg/printers/tablegenerator.go` 41-43行目（PrintHandler interface）
- E-06: `pkg/printers/tablegenerator.go` 78-121行目（GenerateTable関数）
- E-07: `pkg/printers/tablegenerator.go` 125-144行目（TableHandler関数）
- E-08: `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` 95行目（PrintObj関数）
- E-09: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 32行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Holder, Ageの3つ | E-01 | ○ |
| C-02 | HolderIdentityはポインタ型でnilの場合は空文字表示 | E-02 | ○ |
| C-03 | printLeaseList はリスト内をループしてprintLeaseを呼ぶ | E-03 | ○ |
| C-04 | AgeはtranslateTimestampSinceで変換 | E-02, E-04 | ○ |
| C-05 | translateTimestampSinceはduration.HumanDurationを使用 | E-04 | ○ |
| C-06 | AddHandlers関数内でハンドラ登録される | E-01, E-07 | ○ |
| C-07 | HumanReadableGeneratorのGenerateTableがhandlerMapから呼び出す | E-06 | ○ |
| C-08 | Name項目のFormat属性は"name" | E-01 | ○ |
| C-09 | Wideオプションで追加カラムは無い | E-01 | ○ |
| C-10 | コマンドはkubectl get leasesで使用 | E-09 | ○ |
| C-11 | coordination.k8s.io/v1 APIグループに属する | E-01 | ○ |
| C-12 | パフォーマンス要件（想定件数、目標時間） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値はソースコードから直接導出できない。一般的なkubectl操作の経験則に基づく推定値である。
  - 候補：ベンチマークテスト結果 / Kubernetes公式パフォーマンスドキュメント / SIG-Scalability資料

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義・プリンタ関数の内容はソースコードから直接確認済み
- 0: 低リスク - データフローはコード構造から明確に追跡可能
- 1: 中リスク - パフォーマンス要件は推定値であり、実環境での検証が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, Holder, Age）がソースコード437-441行目と一致しているか
- [ ] HolderIdentityのnil処理が2716-2718行目と一致しているか
- [ ] パフォーマンス要件の数値が妥当か（運用環境の実績と照合）
