---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：32-LeaseCandidate一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 445-453行目（カラム定義とハンドラ登録）
- E-02: `pkg/printers/internalversion/printers.go` 2736-2743行目（printLeaseCandidate関数）
- E-03: `pkg/printers/internalversion/printers.go` 2745-2755行目（printLeaseCandidateList関数）
- E-04: `pkg/printers/internalversion/printers.go` 863-869行目（translateTimestampSince関数）
- E-05: `pkg/printers/tablegenerator.go` 78-121行目（GenerateTable関数）
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 33行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, LeaseName, BinaryVersion, EmulationVersion, Ageの5つ | E-01 | ○ |
| C-02 | 全フィールドが直接値でnil判定不要 | E-02 | ○ |
| C-03 | printLeaseCandidateList はループしてprintLeaseCandidateを呼ぶ | E-03 | ○ |
| C-04 | AgeはtranslateTimestampSinceで変換 | E-02, E-04 | ○ |
| C-05 | AddHandlers関数内で445行目にカラム定義 | E-01 | ○ |
| C-06 | coordination.k8s.io/v1alpha2 APIグループに属する | E-01 | ○ |
| C-07 | Name項目のFormat属性は"name" | E-01 | ○ |
| C-08 | Wideオプションで追加カラムは無い | E-01 | ○ |
| C-09 | コマンドはkubectl get leasecandidatesで使用 | E-06 | ○ |
| C-10 | 2741行目で5つのフィールドをセルに追加 | E-02 | ○ |
| C-11 | パフォーマンス要件（想定件数、目標時間） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はソースコードから導出不可能。アルファ機能のため運用実績データも限定的。
  - 候補：KEP資料 / フィーチャーゲート仕様 / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義・プリンタ関数はソースコードから直接確認済み
- 1: 中リスク - v1alpha2 APIのため将来的にフィールド変更の可能性がある
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, LeaseName, BinaryVersion, EmulationVersion, Age）がソースコード445-451行目と一致しているか
- [ ] 2741行目の各フィールドの順序が正しいか
- [ ] v1alpha2 の APIバージョンが最新のソースコードで変更されていないか
