---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：33-StorageClass一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 455-465行目（カラム定義とハンドラ登録）
- E-02: `pkg/printers/internalversion/printers.go` 2646-2675行目（printStorageClass関数）
- E-03: `pkg/printers/internalversion/printers.go` 2677-2687行目（printStorageClassList関数）
- E-04: `pkg/apis/storage/util/helpers.go` 29-32行目（IsDefaultAnnotation関数）
- E-05: `pkg/printers/internalversion/printers.go` 863-869行目（translateTimestampSince関数）
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 34行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Provisioner, ReclaimPolicy, VolumeBindingMode, AllowVolumeExpansion, Ageの6つ | E-01 | ○ |
| C-02 | デフォルトSCにはName末尾に"(default)"が付与される | E-02, E-04 | ○ |
| C-03 | IsDefaultAnnotationでアノテーション判定 | E-04 | ○ |
| C-04 | ReclaimPolicyはポインタ型でnilなら"Delete" | E-02 | ○ |
| C-05 | VolumeBindingModeはポインタ型でnilなら"Immediate" | E-02 | ○ |
| C-06 | AllowVolumeExpansionはポインタ型でnilならfalse | E-02 | ○ |
| C-07 | AgeはtranslateTimestampSinceで変換 | E-02, E-05 | ○ |
| C-08 | printStorageClassListはループしてprintStorageClassを呼ぶ | E-03 | ○ |
| C-09 | AddHandlers関数内で455行目にカラム定義 | E-01 | ○ |
| C-10 | クラスタスコープリソース（Namespaceなし） | E-01 | ○ |
| C-11 | Name項目のFormat属性は"name" | E-01 | ○ |
| C-12 | コマンドはkubectl get scで使用 | E-06 | ○ |
| C-13 | storage.k8s.io/v1 APIグループに属する | E-01 | ○ |
| C-14 | パフォーマンス要件（想定件数、目標時間） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は推定値。StorageClassは通常少数のため影響は小さい。
  - 候補：運用環境での実績値 / ストレージベンダードキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義・nil処理・デフォルト値はソースコードから直接確認済み
- 0: 低リスク - IsDefaultAnnotation の判定ロジックもソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（6カラム）がソースコード455-462行目と一致しているか
- [ ] nil時のデフォルト値（Delete, Immediate, false）が2656-2668行目と一致しているか
- [ ] IsDefaultAnnotation の判定ロジックが helpers.go 32行目と整合しているか
