---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-Status出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 476-482行目（カラム定義とハンドラ登録）
- E-02: `pkg/printers/internalversion/printers.go` 2757-2764行目（printStatus関数）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 36行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはStatus, Reason, Messageの3つ | E-01 | ○ |
| C-02 | printStatusはリスト版を持たない | E-01 | ○ |
| C-03 | Reasonはstring()でキャストして表示 | E-02 | ○ |
| C-04 | Status, Reason, Messageの3フィールドをセルに追加 | E-02 | ○ |
| C-05 | AddHandlers関数内で476行目にカラム定義 | E-01 | ○ |
| C-06 | Status型はmetav1パッケージ | E-02 | ○ |
| C-07 | printStatusの引数は*metav1.Status | E-02 | ○ |
| C-08 | Name項目のFormat属性は設定されていない | E-01 | ○ |
| C-09 | Statusオブジェクトは単一で返される | E-01 | ○ |
| C-10 | 帳票一覧のカラム説明：Status/Reason/Messageカラムを持つ | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。Status出力はシンプルな構成であり、ソースコードから全情報が確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目についてソースコードから根拠を確認済み
- 0: 低リスク - シンプルな構成で誤解の余地が少ない

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Status, Reason, Message）がソースコード476-480行目と一致しているか
- [ ] 2761行目のReasonのstring()キャストが正しいか
