---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：36-ControllerRevision一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 484-491行目（カラム定義とハンドラ登録）
- E-02: `pkg/printers/internalversion/printers.go` 2807-2827行目（printControllerRevision関数）
- E-03: `pkg/printers/internalversion/printers.go` 2829-2839行目（printControllerRevisionList関数）
- E-04: `pkg/printers/internalversion/printers.go` 2843-2849行目（formatResourceName関数）
- E-05: `pkg/printers/internalversion/printers.go` 863-869行目（translateTimestampSince関数）
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 37行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Controller, Revision, Ageの4つ | E-01 | ○ |
| C-02 | Controller値はGetControllerOfで取得 | E-02 | ○ |
| C-03 | コントローラー未設定時は"\<none\>" | E-02 | ○ |
| C-04 | APIVersionをParseGroupVersionで解析 | E-02 | ○ |
| C-05 | formatResourceNameで"kind/name"形式に整形 | E-02, E-04 | ○ |
| C-06 | formatResourceNameはstrings.ToLowerを使用 | E-04 | ○ |
| C-07 | ParseGroupVersionエラー時にエラーを返す | E-02 | ○ |
| C-08 | printControllerRevisionListはループ処理 | E-03 | ○ |
| C-09 | AgeはtranslateTimestampSinceで変換 | E-02, E-05 | ○ |
| C-10 | AddHandlers関数内で484行目にカラム定義 | E-01 | ○ |
| C-11 | apps/v1 APIグループに属する | E-01 | ○ |
| C-12 | コマンドはkubectl get controllerrevisionsで使用 | E-06 | ○ |
| C-13 | パフォーマンス要件（想定件数、目標時間） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件はrevisionHistoryLimitの設定値に依存するが、具体的な数値はソースコードから直接導出できない。
  - 候補：revisionHistoryLimit デフォルト値の確認 / 運用環境での実績値

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義・プリンタ関数はソースコードから直接確認済み
- 0: 低リスク - GetControllerOf / ParseGroupVersion / formatResourceName の処理フローは明確
- 1: 中リスク - ParseGroupVersionのエラーハンドリングが行生成全体に影響する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, Controller, Revision, Age）がソースコード484-489行目と一致しているか
- [ ] Controller列のフォーマット（"kind/name" 小文字）が2812-2821行目と一致しているか
- [ ] ParseGroupVersionエラー時の挙動が正しく記載されているか
