---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：38-PriorityClass一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 502-510行目（カラム定義とハンドラ登録）
- E-02: `pkg/printers/internalversion/printers.go` 2895-2912行目（printPriorityClass関数）
- E-03: `pkg/printers/internalversion/printers.go` 2914-2924行目（printPriorityClassList関数）
- E-04: `pkg/printers/internalversion/printers.go` 863-869行目（translateTimestampSince関数）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 39行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Value, Global-Default, Age, PreemptionPolicyの5つ | E-01 | ○ |
| C-02 | Valueはint64にキャストされる | E-02 | ○ |
| C-03 | GlobalDefaultはbool型で表示 | E-02 | ○ |
| C-04 | PreemptionPolicyはWideモードのみ表示 | E-02 | ○ |
| C-05 | PreemptionPolicyはポインタ型でnilなら空文字 | E-02 | ○ |
| C-06 | options.Wideでモード判定 | E-02 | ○ |
| C-07 | printPriorityClassListはループ処理 | E-03 | ○ |
| C-08 | AgeはtranslateTimestampSinceで変換 | E-02, E-04 | ○ |
| C-09 | AddHandlers関数内で502行目にカラム定義 | E-01 | ○ |
| C-10 | scheduling.k8s.io/v1 APIグループに属する | E-01 | ○ |
| C-11 | クラスタスコープリソース | E-01 | ○ |
| C-12 | コマンドはkubectl get priorityclassesで使用 | E-05 | ○ |
| C-13 | パフォーマンス要件（想定件数、目標時間） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件は推定値。PriorityClassは通常少数のため影響は小さい。
  - 候補：運用環境での実績値

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義・Wideモード分岐はソースコードから確認済み
- 0: 低リスク - int64キャストとnilチェックは明確
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（5カラム）がソースコード502-508行目と一致しているか
- [ ] Wideモード分岐が2904行目で確認できるか
- [ ] PreemptionPolicyのnilチェックが2906行目で確認できるか
- [ ] int64キャストが2903行目で確認できるか
