---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-ReplicationController一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行 129-138（replicationControllerColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 139-140（TableHandler 登録）
- E-03: `pkg/printers/internalversion/printers.go` 行 1162-1181（printReplicationController 関数）
- E-04: `pkg/printers/internalversion/printers.go` 行 1183-1193（printReplicationControllerList 関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RC のカラムは Name, Desired, Current, Ready, Age の 5 列 + wide 3 列 | E-01 | ○ |
| C-02 | Desired は ptr.Deref(Spec.Replicas, 0) で取得 | E-03 (行1167) | ○ |
| C-03 | Current は Status.Replicas から取得 | E-03 (行1168) | ○ |
| C-04 | Ready は Status.ReadyReplicas から取得 | E-03 (行1169) | ○ |
| C-05 | Desired/Current/Ready は int64 にキャスト | E-03 (行1171) | ○ |
| C-06 | Age は translateTimestampSince で変換 | E-03 (行1171) | ○ |
| C-07 | Wide 時に Containers, Images, Selector を追加 | E-03 (行1172-1179) | ○ |
| C-08 | Wide 時 Template nil チェックが行われる | E-03 (行1174) | ○ |
| C-09 | Containers/Images は layoutContainerCells で生成 | E-03 (行1177) | ○ |
| C-10 | Selector は labels.FormatLabels で生成 | E-03 (行1178) | ○ |
| C-11 | Containers, Images, Selector の Priority は 1 | E-01 (行135-137) | ○ |
| C-12 | printReplicationControllerList は Items を順に委譲 | E-04 | ○ |
| C-13 | Name カラムは Format: "name" を持つ | E-01 (行130) | ○ |
| C-14 | Desired/Current/Ready の Type は "integer" | E-01 (行131-133) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: RC の print 関数は明快で低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] replicationControllerColumnDefinitions の 8 カラム（5 通常 + 3 wide）が設計書と一致しているか確認
- [ ] ptr.Deref による Replicas デフォルト処理が正しく記述されているか確認
- [ ] Wide 出力時の Template nil チェックが正しいか確認
