---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-MutatingWebhookConfiguration一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/apis/admissionregistration/types.go` - MutatingWebhookConfiguration構造体（717行目）
- E-02: `pkg/printers/internalversion/printers.go` - mutatingWebhookColumnDefinitions（575-579行目）
- E-03: `pkg/printers/internalversion/printers.go` - printMutatingWebhook関数（1736-1742行目）
- E-04: `pkg/printers/internalversion/printers.go` - printMutatingWebhookList関数（1744-1754行目）
- E-05: `pkg/printers/internalversion/printers_test.go` - テストケース（7415行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MutatingWebhookConfigurationは3カラム（Name, Webhooks, Age）で表示 | E-02 | ○ |
| C-02 | Webhooksカラムはlen(obj.Webhooks)で算出 | E-03 (1740行目) | ○ |
| C-03 | AgeはtranslateTimestampSinceで表示 | E-03 (1740行目) | ○ |
| C-04 | printMutatingWebhookは1736行目に定義 | E-03 | ○ |
| C-05 | printMutatingWebhookListは1744行目に定義 | E-04 | ○ |
| C-06 | Webhooksフィールドの説明がWebhooksカラムのDescriptionに対応 | E-02 (577行目) | ○ |
| C-07 | クラスタスコープのリソースである | E-01 | ○ |
| C-08 | admissionregistration APIグループに属する | E-01 | ○ |
| C-09 | テーブルハンドラーは580-581行目で登録 | E-02 | ○ |
| C-10 | printMutatingWebhookListはリストのアイテムをループ処理 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな3カラム構成
- 0: 低リスク - 出力ロジックが単純（カウントと時間表示のみ）

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, Webhooks, Age）がソースコードと一致しているか
- [ ] Webhooksカラムの計算方法（len(obj.Webhooks)）が正しいか
