---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-ValidatingAdmissionPolicyBinding一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/apis/admissionregistration/types.go` - ValidatingAdmissionPolicyBinding構造体
- E-02: `pkg/printers/internalversion/printers.go` - validatingAdmissionPolicyBindingカラム定義（600-605行目）
- E-03: `pkg/printers/internalversion/printers.go` - printValidatingAdmissionPolicyBinding関数（1800-1820行目）
- E-04: `pkg/printers/internalversion/printers.go` - printValidatingAdmissionPolicyBindingList関数（1822-1832行目）
- E-05: `pkg/printers/internalversion/printers_test.go` - テストケース（7194行目, 7433行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ValidatingAdmissionPolicyBindingは4カラム（Name, PolicyName, ParamRef, Age）で表示 | E-02 | ○ |
| C-02 | PolicyNameカラムはSpec.PolicyNameを表示 | E-03 (1818行目) | ○ |
| C-03 | ParamRefがnilの場合`<unset>`表示 | E-03 (1804行目) | ○ |
| C-04 | ParamRef.Nameが設定されNamespaceがある場合Namespace/Name形式 | E-03 (1807-1808行目) | ○ |
| C-05 | ParamRef.Nameが設定されNamespaceがない場合*/Name形式 | E-03 (1810-1813行目) | ○ |
| C-06 | ParamRef.Nameが未設定でSelectorがある場合Selector.String() | E-03 (1814-1816行目) | ○ |
| C-07 | コメントでクラスタスコープ判別不可の理由が記載 | E-03 (1810-1812行目) | ○ |
| C-08 | AgeはtranslateTimestampSinceで表示 | E-03 (1818行目) | ○ |
| C-09 | printValidatingAdmissionPolicyBindingは1800行目に定義 | E-03 | ○ |
| C-10 | printValidatingAdmissionPolicyBindingListは1822行目に定義 | E-04 | ○ |
| C-11 | クラスタスコープのリソースである | E-01 | ○ |
| C-12 | admissionregistration APIグループに属する | E-01 | ○ |
| C-13 | テーブルハンドラーは606-607行目で登録 | E-02 | ○ |
| C-14 | PolicyNameカラムの説明は"policy definition which the policy binding binded to" | E-02 (602行目) | ○ |
| C-15 | ParamRefカラムの説明は"param resource which sets the configuration param" | E-02 (603行目) | ○ |
| C-16 | テストケースが7194行目と7433行目に存在 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義がソースコードで確認済み
- 0: 低リスク - ParamRefの条件分岐ロジックが全パターンソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 4カラム（Name, PolicyName, ParamRef, Age）がソースコードと一致しているか
- [ ] ParamRefの条件分岐（nil/Name+Namespace/Name/Selector）が正しいか
- [ ] Namespace未設定時の`*/`プレフィックスの意味が正しく説明されているか
