---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：49-MutatingAdmissionPolicy一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **MutatingAdmissionPolicyの導入バージョン（v1.32 alpha）**：ソースコードのコメントから推定

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/apis/admissionregistration/types.go` - MutatingAdmissionPolicy構造体（1179行目）
- E-02: `pkg/apis/admissionregistration/types.go` - k8s:prerelease-lifecycle-gen:introduced=1.32コメント（1189行目付近）
- E-03: `pkg/printers/internalversion/printers.go` - mutatingAdmissionPolicyカラム定義（609-614行目）
- E-04: `pkg/printers/internalversion/printers.go` - printMutatingAdmissionPolicy関数（1834-1844行目）
- E-05: `pkg/printers/internalversion/printers.go` - printMutatingAdmissionPolicyList関数（1846-1856行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MutatingAdmissionPolicyは4カラム（Name, Mutations, ParamKind, Age）で表示 | E-03 | ○ |
| C-02 | MutationsカラムはMutationsカラム名で、len(obj.Spec.Mutations)で算出 | E-03, E-04 (1842行目) | ○ |
| C-03 | ParamKindがnilの場合`<unset>`表示 | E-04 (1838行目) | ○ |
| C-04 | ParamKindが非nilの場合APIVersion+"/"+Kind形式 | E-04 (1840行目) | ○ |
| C-05 | AgeはtranslateTimestampSinceで表示 | E-04 (1842行目) | ○ |
| C-06 | printMutatingAdmissionPolicyは1834行目に定義 | E-04 | ○ |
| C-07 | printMutatingAdmissionPolicyListは1846行目に定義 | E-05 | ○ |
| C-08 | クラスタスコープのリソースである | E-01 | ○ |
| C-09 | admissionregistration APIグループに属する | E-01 | ○ |
| C-10 | テーブルハンドラーは615-616行目で登録 | E-03 | ○ |
| C-11 | Spec.ParamKindはポインタ型 | E-04 (1839行目のnil判定) | ○ |
| C-12 | ValidatingAdmissionPolicyと類似構造 | E-01, E-04 | ○ |
| C-13 | MutatingAdmissionPolicyBindingと組み合わせて使用 | E-01 | ○ |
| C-14 | v1.32で導入されたalpha機能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- v1.32でalphaというステータスの正確な確認にはリリースノートやKEP文書が必要
  - 候補：Kubernetes公式リリースノート / KEP-3962 / CHANGELOG-1.32.md
  - 注: types.goに`k8s:prerelease-lifecycle-gen:introduced=1.32`コメントがあるが、alphaかbetaかはフィーチャーゲート設定の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義と出力ロジックがソースコードで確認済み
- 1: 中リスク - 機能の成熟度（alpha/beta/GA）の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 4カラム（Name, Mutations, ParamKind, Age）がソースコードと一致しているか
- [ ] MutationsカラムがValidationsではなくMutationsである点を確認
- [ ] MutatingAdmissionPolicyの機能ステータス（alpha/beta）が正しいか確認
