---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-ReplicaSet一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行 142-150（replicaSetColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 152-153（TableHandler 登録）
- E-03: `pkg/printers/internalversion/printers.go` 行 1195-1210（printReplicaSet 関数）
- E-04: `pkg/printers/internalversion/printers.go` 行 1212-1222（printReplicaSetList 関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RS のカラムは Name, Desired, Current, Ready, Age の 5 列 + wide 3 列 | E-01 | ○ |
| C-02 | Desired は Spec.Replicas を直接 int64 キャスト（ptr.Deref 不使用） | E-03 (行1200) | ○ |
| C-03 | Current は Status.Replicas | E-03 (行1201) | ○ |
| C-04 | Ready は Status.ReadyReplicas | E-03 (行1202) | ○ |
| C-05 | int64 キャストでセルに追加 | E-03 (行1204) | ○ |
| C-06 | Age は translateTimestampSince | E-03 (行1204) | ○ |
| C-07 | Wide 時に Containers, Images, Selector を追加 | E-03 (行1205-1208) | ○ |
| C-08 | Containers/Images は layoutContainerCells | E-03 (行1206) | ○ |
| C-09 | Selector は metav1.FormatLabelSelector（RC と異なる） | E-03 (行1207) | ○ |
| C-10 | Containers, Images, Selector の Priority は 1 | E-01 (行148-150) | ○ |
| C-11 | printReplicaSetList は Items を順に委譲 | E-04 | ○ |
| C-12 | Name カラムは Format: "name" | E-01 (行143) | ○ |
| C-13 | Desired/Current/Ready の Type は "integer" | E-01 (行144-146) | ○ |
| C-14 | printReplicaSet と printReplicaSetList が登録 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: RS の print 関数は RC とほぼ同構造で低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] replicaSetColumnDefinitions の 8 カラムが設計書と一致しているか確認
- [ ] Spec.Replicas の取得方法が RC と異なる（ptr.Deref 不使用）点が正しいか確認
- [ ] Selector が metav1.FormatLabelSelector で整形される点が正しいか確認
