---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-MutatingAdmissionPolicyBinding一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/apis/admissionregistration/types.go` - MutatingAdmissionPolicyBinding構造体
- E-02: `pkg/printers/internalversion/printers.go` - mutatingAdmissionPolicyBindingカラム定義（618-623行目）
- E-03: `pkg/printers/internalversion/printers.go` - printMutatingAdmissionPolicyBinding関数（1858-1878行目）
- E-04: `pkg/printers/internalversion/printers.go` - printMutatingAdmissionPolicyBindingList関数（1880-1890行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MutatingAdmissionPolicyBindingは4カラム（Name, PolicyName, ParamRef, Age）で表示 | E-02 | ○ |
| C-02 | PolicyNameカラムはSpec.PolicyNameを表示 | E-03 (1876行目) | ○ |
| C-03 | ParamRefがnilの場合`<unset>`表示 | E-03 (1862行目) | ○ |
| C-04 | ParamRef.Nameが設定されNamespaceがある場合Namespace/Name形式 | E-03 (1865-1866行目) | ○ |
| C-05 | ParamRef.Nameが設定されNamespaceがない場合*/Name形式 | E-03 (1868-1871行目) | ○ |
| C-06 | ParamRef.Nameが未設定でSelectorがある場合Selector.String() | E-03 (1872-1874行目) | ○ |
| C-07 | コメントでクラスタスコープ判別不可の理由が記載 | E-03 (1868-1870行目) | ○ |
| C-08 | AgeはtranslateTimestampSinceで表示 | E-03 (1876行目) | ○ |
| C-09 | printMutatingAdmissionPolicyBindingは1858行目に定義 | E-03 | ○ |
| C-10 | printMutatingAdmissionPolicyBindingListは1880行目に定義 | E-04 | ○ |
| C-11 | クラスタスコープのリソースである | E-01 | ○ |
| C-12 | admissionregistration APIグループに属する | E-01 | ○ |
| C-13 | テーブルハンドラーは624-625行目で登録 | E-02 | ○ |
| C-14 | ValidatingAdmissionPolicyBindingとParamRefロジックが同一 | E-03 | ○ |
| C-15 | PolicyNameカラムの説明がValidatingAdmissionPolicyBindingと同一 | E-02 (620行目) | ○ |
| C-16 | ParamRefカラムの説明がValidatingAdmissionPolicyBindingと同一 | E-02 (621行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義がソースコードで確認済み
- 0: 低リスク - ParamRefの条件分岐ロジックがValidatingAdmissionPolicyBindingと同一パターンで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 4カラム（Name, PolicyName, ParamRef, Age）がソースコードと一致しているか
- [ ] ParamRefの条件分岐（nil/Name+Namespace/Name/Selector）が正しいか
- [ ] ValidatingAdmissionPolicyBindingとのロジック同一性が正しいか
