---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：51-FlowSchema一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **FlowSchemaSequenceソートロジックの詳細仕様**：apihelpers.FlowSchemaSequenceの実装は直接未確認
  2. **想定データ件数**：根拠不足（実環境依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/printers/internalversion/printers.go` 627-636行目（flowSchemaColumnDefinitions定義）
- E-02: `pkg/printers/internalversion/printers.go` 2978-2999行目（printFlowSchema関数）
- E-03: `pkg/printers/internalversion/printers.go` 3001-3016行目（printFlowSchemaList関数）
- E-04: `pkg/printers/internalversion/printers.go` 93行目（AddHandlers関数）
- E-05: `pkg/printers/tablegenerator.go` 125行目（TableHandler関数）
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 52行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FlowSchemaのテーブルカラムは6列（Name, PriorityLevel, MatchingPrecedence, DistinguisherMethod, Age, MissingPL） | E-01 | ○ |
| C-02 | DistinguisherMethodがnilの場合`<none>`を表示 | E-02（2985-2988行目） | ○ |
| C-03 | MissingPLカラムはFlowSchemaConditionDanglingのStatusを表示 | E-02（2989-2995行目） | ○ |
| C-04 | MissingPLがDangling条件なしの場合`?`を表示 | E-02（2989行目） | ○ |
| C-05 | FlowSchemaListはFlowSchemaSequenceでソートされる | E-03（3003-3007行目） | ○ |
| C-06 | printFlowSchema関数はTableRow配列を返す | E-02 | ○ |
| C-07 | AddHandlers関数でFlowSchemaハンドラが登録される | E-04, E-01 | ○ |
| C-08 | コマンドは`kubectl get flowschemas` | E-06 | ○ |
| C-09 | AgeはtranslateTimestampSinceで相対時間に変換 | E-02（2996行目） | ○ |
| C-10 | MatchingPrecedenceはint64にキャストされる | E-02（2996行目） | ○ |
| C-11 | FlowSchemaはクラスタスコープリソース | E-06 | ○ |
| C-12 | TableHandler関数でカラム定義と印刷関数が関連付けられる | E-05 | ○ |
| C-13 | PriorityLevelはobj.Spec.PriorityLevelConfiguration.Nameから取得 | E-02（2984行目） | ○ |
| C-14 | 想定データ件数は数十件 | **根拠なし** | △ |
| C-15 | FlowSchemaSequenceはMatchingPrecedenceとNameの組み合わせでソート | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数（数十件）は実環境依存であり、ソースコードからは直接確認できない
  - 候補：Kubernetesデフォルトマニフェスト / ドキュメント / 実環境調査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力カラムの仕様はソースコードから明確に読み取れる
- 0: 低リスク - ソート順序もコードで確認可能
- 1: 中リスク - FlowSchemaSequenceの詳細実装（util パッケージ）は直接確認していない

## 6) レビュアーチェックリスト（最小）
- [ ] FlowSchemaSequenceのソートロジック（MatchingPrecedence昇順 + Name昇順）が正しいか確認
- [ ] MissingPLカラムの初期値`?`がDangling条件不在時に正しいか確認
- [ ] 想定データ件数が実環境と合致するか確認
