---
generated_at: 2026-02-02 10:01:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：52-PriorityLevelConfiguration一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数**：根拠不足（実環境依存）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 638-648行目（priorityLevelColumnDefinitions定義）
- E-02: `pkg/printers/internalversion/printers.go` 3058-3078行目（printPriorityLevelConfiguration関数）
- E-03: `pkg/printers/internalversion/printers.go` 3080-3090行目（printPriorityLevelConfigurationList関数）
- E-04: `pkg/printers/internalversion/printers.go` 93行目（AddHandlers関数）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 53行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブルカラムは7列（Name, Type, NominalConcurrencyShares, Queues, HandSize, QueueLengthLimit, Age） | E-01 | ○ |
| C-02 | Spec.Limitedがnilの場合、NCS/Queues/HandSize/QueueLengthLimitは`<none>` | E-02（3063-3066行目） | ○ |
| C-03 | Spec.Limitedが非nilの場合NominalConcurrencySharesを取得 | E-02（3068行目） | ○ |
| C-04 | Queuing設定がnilの場合キュー関連は`<none>` | E-02（3069行目） | ○ |
| C-05 | TypeはSpec.Typeをstring変換して取得 | E-02（3075行目） | ○ |
| C-06 | AgeはtranslateTimestampSinceで変換 | E-02（3075行目） | ○ |
| C-07 | printPriorityLevelConfigurationList関数はリスト内各アイテムを処理 | E-03 | ○ |
| C-08 | AddHandlers関数でハンドラが登録される | E-04 | ○ |
| C-09 | コマンドは`kubectl get prioritylevelconfigurations` | E-05 | ○ |
| C-10 | クラスタスコープリソースである | E-05 | ○ |
| C-11 | Exempt/Limitedの2タイプがある | E-02（3067行目分岐） | ○ |
| C-12 | LimitResponse.Queuingが非nilの場合のみQueues/HandSize/QueueLengthLimit取得 | E-02（3069-3073行目） | ○ |
| C-13 | ncs, queues, handSize, queueLengthLimitの初期値はinterface{}("<none>") | E-02（3063-3066行目） | ○ |
| C-14 | 想定データ件数は数件〜十数件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数は実環境依存であり、ソースコードからは直接確認できない
  - 候補：Kubernetesデフォルトマニフェスト / ドキュメント / 実環境調査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力カラムの仕様はソースコードから明確に読み取れる
- 0: 低リスク - nil判定ロジックが明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] Exempt/Limited以外のTypeが存在しないか確認
- [ ] LimitResponse戦略がRejectの場合のQueuing動作を確認
- [ ] 想定データ件数が実環境と合致するか確認
