---
generated_at: 2026-02-02 10:02:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：53-StorageVersion一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数**：根拠不足（APIリソース種類数に依存）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 650-657行目（storageVersionColumnDefinitions定義）
- E-02: `pkg/printers/internalversion/printers.go` 3018-3028行目（printStorageVersion関数）
- E-03: `pkg/printers/internalversion/printers.go` 3030-3044行目（formatStorageVersions関数）
- E-04: `pkg/printers/internalversion/printers.go` 3046-3056行目（printStorageVersionList関数）
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 54行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブルカラムは4列（Name, CommonEncodingVersion, StorageVersions, Age） | E-01 | ○ |
| C-02 | CommonEncodingVersionがnilの場合`<unset>`を表示 | E-02（3022-3025行目） | ○ |
| C-03 | StorageVersionsはformatStorageVersionsで整形 | E-02（3026行目） | ○ |
| C-04 | formatStorageVersionsは最大3件まで表示 | E-03（3032行目: max=3） | ○ |
| C-05 | 4件以上の場合`(+N more)`を付加 | E-03（3038-3039行目: more=true） | ○ |
| C-06 | 各サーバ情報は`APIServerID=EncodingVersion`形式 | E-03（3037行目） | ○ |
| C-07 | AgeはtranslateTimestampSinceで変換 | E-02（3026行目） | ○ |
| C-08 | printStorageVersionListは各アイテムを処理 | E-04 | ○ |
| C-09 | コマンドは`kubectl get storageversions` | E-05 | ○ |
| C-10 | クラスタスコープリソースである | E-05 | ○ |
| C-11 | listWithMoreString関数で省略表示を整形 | E-03（3043行目） | ○ |
| C-12 | 想定データ件数は数十件〜数百件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数はAPIリソースの種類数に依存し、ソースコードからは直接確認できない
  - 候補：実環境調査 / Kubernetes APIリソース一覧ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力カラムの仕様はソースコードから明確に読み取れる
- 0: 低リスク - formatStorageVersionsの省略表示ロジックも明確

## 6) レビュアーチェックリスト（最小）
- [ ] listWithMoreString関数の出力フォーマットが期待通りか確認
- [ ] CommonEncodingVersionがnilになるケースの網羅性を確認
- [ ] 想定データ件数が実環境と合致するか確認
