---
generated_at: 2026-02-02 10:03:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-Scale出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 659-665行目（scaleColumnDefinitions定義）
- E-02: `pkg/printers/internalversion/printers.go` 3149-3155行目（printScale関数）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 55行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブルカラムは4列（Name, Desired, Available, Age） | E-01 | ○ |
| C-02 | DesiredはSpec.Replicasからint64にキャストして取得 | E-02（3153行目） | ○ |
| C-03 | AvailableはStatus.Replicasからint64にキャストして取得 | E-02（3153行目） | ○ |
| C-04 | AgeはtranslateTimestampSinceで変換 | E-02（3153行目） | ○ |
| C-05 | printScaleList関数は存在しない（サブリソースのため） | E-01（665行目:printScaleのみ登録） | ○ |
| C-06 | ScaleはautoscalingパッケージのAPIリソース | E-01（661-662行目:autoscalingv1参照） | ○ |
| C-07 | DesiredカラムのDescriptionはautoscalingv1.ScaleSpec.SwaggerDoc | E-01（661行目） | ○ |
| C-08 | AvailableカラムのDescriptionはautoscalingv1.ScaleStatus.SwaggerDoc | E-01（662行目） | ○ |
| C-09 | コマンドは`kubectl get scale` | E-03 | ○ |
| C-10 | 想定データ件数は1件（単一サブリソース） | E-01（List関数なし） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Scaleリソースは構造がシンプルで、出力仕様も明確

## 6) レビュアーチェックリスト（最小）
- [ ] Spec.ReplicasとStatus.Replicasのint32->int64キャストで情報欠落がないか確認
- [ ] Scaleサブリソースの利用コマンドが正確か確認
