---
generated_at: 2026-02-02 10:08:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：59-DeviceTaintRule一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数**：根拠不足（実環境依存）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 699-713行目（deviceTaintColumnDefinitions定義）
- E-02: `pkg/printers/internalversion/printers.go` 3263-3275行目（printDeviceTaint関数）
- E-03: `pkg/printers/internalversion/printers.go` 3277-3287行目（printDeviceTaintRuleList関数）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 60行目（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブルカラムは6列（Name, Key, Value, Effect, TimeAdded, Age） | E-01 | ○ |
| C-02 | フィルタ条件（DeviceSelector）はテーブル出力に含まれない | E-01（701-703行目コメント） | ○ |
| C-03 | KeyはDeviceTaint.SwaggerDocのkeyから説明取得 | E-01（705行目） | ○ |
| C-04 | TimeAddedがnilの場合は空文字列 | E-02（3268-3271行目） | ○ |
| C-05 | TimeAddedが非nilの場合はtranslateTimestampSinceで変換 | E-02（3270行目） | ○ |
| C-06 | KeyはTaint.Keyをstring()でキャスト | E-02（3272行目） | ○ |
| C-07 | EffectはTaint.Effectをstring()でキャスト | E-02（3272行目） | ○ |
| C-08 | 出力順序はName, Key, Value, Effect, timeAdded, Age | E-02（3272行目） | ○ |
| C-09 | AgeはtranslateTimestampSinceで変換 | E-02（3272行目） | ○ |
| C-10 | printDeviceTaintRuleListは各アイテムを反復処理 | E-03 | ○ |
| C-11 | コマンドは`kubectl get devicetaintrules` | E-04 | ○ |
| C-12 | クラスタスコープリソースである | E-04 | ○ |
| C-13 | TimeAddedとAgeは通常同じ値だが必ずしも同一ではない | E-01（708行目コメント） | ○ |
| C-14 | 想定データ件数は数件〜数十件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定データ件数は実環境のデバイスTaint運用に依存し、ソースコードからは直接確認できない
  - 候補：実環境調査 / DRAドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力カラムの仕様はソースコードから明確に読み取れる
- 0: 低リスク - TimeAddedのnil判定も明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] DeviceTaintのEffect値の種類（NoSchedule, NoExecute等）が網羅されているか確認
- [ ] TimeAddedとAgeの差異が発生するケースの実例を確認
- [ ] 想定データ件数が実環境と合致するか確認
