---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-DaemonSet一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行 155-167（daemonSetColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 168-169（TableHandler 登録）
- E-03: `pkg/printers/internalversion/printers.go` 行 1561-1578（printDaemonSet 関数）
- E-04: `pkg/printers/internalversion/printers.go` 行 1580-1590（printDaemonSetList 関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DS のカラムは 8 通常 + 3 wide の計 11 列 | E-01 | ○ |
| C-02 | Desired は Status.DesiredNumberScheduled から取得 | E-03 (行1566) | ○ |
| C-03 | Current は Status.CurrentNumberScheduled | E-03 (行1567) | ○ |
| C-04 | Ready は Status.NumberReady | E-03 (行1568) | ○ |
| C-05 | Up-to-date は Status.UpdatedNumberScheduled | E-03 (行1569) | ○ |
| C-06 | Available は Status.NumberAvailable | E-03 (行1570) | ○ |
| C-07 | 全ステータス値は int64 にキャスト | E-03 (行1572) | ○ |
| C-08 | Node Selector は labels.FormatLabels で整形 | E-03 (行1572) | ○ |
| C-09 | Node Selector データソースは Spec.Template.Spec.NodeSelector | E-03 (行1572) | ○ |
| C-10 | Age は translateTimestampSince | E-03 (行1572) | ○ |
| C-11 | Wide 時に Containers, Images, Selector を追加 | E-03 (行1573-1576) | ○ |
| C-12 | Containers/Images は layoutContainerCells | E-03 (行1574) | ○ |
| C-13 | Selector は metav1.FormatLabelSelector | E-03 (行1575) | ○ |
| C-14 | Containers, Images, Selector の Priority は 1 | E-01 (行164-166) | ○ |
| C-15 | printDaemonSetList は Items を順に委譲 | E-04 | ○ |
| C-16 | Name カラムは Format: "name" | E-01 (行156) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: DS の print 関数はステータスフィールドの直接マッピングで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] daemonSetColumnDefinitions の 11 カラムが設計書と一致しているか確認
- [ ] 5 つのステータスフィールドの取得元が Status から正しく取得されているか確認
- [ ] Node Selector が通常カラム（Priority=0）に含まれている点が正しいか確認
