---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-Workload一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - 根拠不足の項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 740-745行目（workloadColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 3324-3344行目（printWorkload, printWorkloadList関数）
- E-03: `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` 95-167行目（HumanReadablePrinter.PrintObj）
- E-04: `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` 583-589行目（translateTimestampSince）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カラムはName, Ageの2つ | E-01 | ○ |
| C-02 | NameカラムにFormat:"name"が設定 | E-01 | ○ |
| C-03 | printWorkloadがobj.Nameとobj.CreationTimestampを使用 | E-02 | ○ |
| C-04 | translateTimestampSinceで経過時間を計算 | E-02, E-04 | ○ |
| C-05 | printWorkloadListがリスト内の各要素をprintWorkloadで処理 | E-02 | ○ |
| C-06 | HumanReadablePrinterでテーブル出力 | E-03 | ○ |
| C-07 | Workloadはscheduling APIグループに属する | E-02 | ○ |
| C-08 | CreationTimestampがゼロ値の場合は`<unknown>`表示 | E-04 | ○ |
| C-09 | tabwriterで列幅自動調整 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠不足の項目なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] カラム定義（Name, Age）がソースコードと一致しているか確認
- [ ] printWorkload関数のロジックが設計書の記載と一致するか確認
