---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-YAML出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 根拠不足の項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/cli-runtime/pkg/printers/yaml.go` 36-38行目（YAMLPrinter構造体定義）
- E-02: `staging/src/k8s.io/cli-runtime/pkg/printers/yaml.go` 41-86行目（PrintObj関数）
- E-03: `staging/src/k8s.io/cli-runtime/pkg/printers/interface.go` 34-38行目（ResourcePrinterインターフェース）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | YAMLPrinterはprintCountフィールドを持つ | E-01 | ○ |
| C-02 | printCountはint64型 | E-01 | ○ |
| C-03 | InternalObjectPreventerで内部オブジェクトチェック | E-02 | ○ |
| C-04 | atomic.AddInt64でスレッドセーフにカウント | E-02 | ○ |
| C-05 | count > 1の場合に`---\n`を出力 | E-02 | ○ |
| C-06 | WatchEventの場合はyaml.Marshal | E-02 | ○ |
| C-07 | runtime.Unknownの場合はyaml.JSONToYAML | E-02 | ○ |
| C-08 | GVKが空の場合はエラー | E-02 | ○ |
| C-09 | 通常オブジェクトはyaml.Marshal | E-02 | ○ |
| C-10 | fmt.Fprintで出力 | E-02 | ○ |
| C-11 | ResourcePrinterインターフェースを実装 | E-03 | ○ |
| C-12 | sigs.k8s.io/yamlライブラリ使用 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠不足の項目なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] PrintObjの3つの分岐がソースコードと一致しているか確認
- [ ] セパレータロジック（printCount）の説明が正確か確認
