---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-クラスタ情報出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 根拠不足の項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` 49-56行目（ClusterInfoOptions構造体）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` 58-75行目（NewCmdClusterInfo関数）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` 77-92行目（Complete関数）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` 94-155行目（Run関数）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` 157-162行目（printService関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClusterInfoOptionsにIOStreams, Namespace, Builder, Clientフィールド | E-01 | ○ |
| C-02 | デフォルトNamespaceはkube-system | E-03 | ○ |
| C-03 | LabelSelectorは`kubernetes.io/cluster-service=true`固定 | E-04 | ○ |
| C-04 | コントロールプレーンURL出力はo.Client.Hostを使用 | E-04 | ○ |
| C-05 | LoadBalancer Ingressがある場合はIP:PortでURL構築 | E-04 | ○ |
| C-06 | LoadBalancerがない場合はAPIサーバプロキシURL構築 | E-04 | ○ |
| C-07 | port.Nameが"https"またはport.Portが443の場合にschemeをhttpsに設定 | E-04 | ○ |
| C-08 | サービス名はkubernetes.io/nameラベル優先、なければmetadata.name | E-04 | ○ |
| C-09 | printServiceは`{name} is running at {link}`形式で出力 | E-05 | ○ |
| C-10 | 末尾にcluster-info dump案内メッセージ出力 | E-04 | ○ |
| C-11 | dumpサブコマンドをAddCommand | E-02 | ○ |
| C-12 | utilnet.JoinSchemeNamePortでサービス名構築 | E-04 | ○ |
| C-13 | resource.NewBuilderでBuilder生成 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠不足の項目なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] URL構築ロジック（LoadBalancer vs プロキシ）がソースコードと一致しているか確認
- [ ] サービス名の優先順位（kubernetes.io/nameラベル > metadata.name）が正確か確認
- [ ] scheme判定ロジック（port.Name=="https" || port.Port==443）が正確か確認
