---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Job一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行 171-179（jobColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 181-182（TableHandler 登録）
- E-03: `pkg/printers/internalversion/printers.go` 行 1224-1274（printJob 関数）
- E-04: `pkg/printers/internalversion/printers.go` 行 1276-1286（printJobList 関数）
- E-05: `pkg/printers/internalversion/printers.go` 行 1096-1103（hasJobCondition 関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Job のカラムは Name, Status, Completions, Duration, Age + wide 3 列 | E-01 | ○ |
| C-02 | Completions は Spec.Completions が nil でなければ "{Succeeded}/{Completions}" | E-03 (行1230-1231) | ○ |
| C-03 | Spec.Completions が nil で Parallelism > 1 なら "{Succeeded}/1 of {Parallelism}" | E-03 (行1237-1238) | ○ |
| C-04 | Spec.Completions が nil で Parallelism <= 1 なら "{Succeeded}/1" | E-03 (行1240) | ○ |
| C-05 | Duration は StartTime nil の場合は空文字列 | E-03 (行1245) | ○ |
| C-06 | Duration は CompletionTime nil の場合は time.Since(StartTime) | E-03 (行1247) | ○ |
| C-07 | Duration は両方設定時は CompletionTime - StartTime | E-03 (行1249) | ○ |
| C-08 | Status: JobComplete が True なら "Complete" | E-03 (行1252-1253) | ○ |
| C-09 | Status: JobFailed が True なら "Failed" | E-03 (行1254-1255) | ○ |
| C-10 | Status: DeletionTimestamp 設定時 "Terminating" | E-03 (行1256-1257) | ○ |
| C-11 | Status: JobSuspended が True なら "Suspended" | E-03 (行1258-1259) | ○ |
| C-12 | Status: JobFailureTarget が True なら "FailureTarget" | E-03 (行1260-1261) | ○ |
| C-13 | Status: JobSuccessCriteriaMet が True なら "SuccessCriteriaMet" | E-03 (行1262-1263) | ○ |
| C-14 | Status: いずれでもなければ "Running" | E-03 (行1264-1265) | ○ |
| C-15 | hasJobCondition は condition.Type と ConditionTrue を確認 | E-05 | ○ |
| C-16 | Name, Status, Completions, Duration, Age をセルに追加 | E-03 (行1268) | ○ |
| C-17 | Wide 時に Containers, Images, Selector を追加 | E-03 (行1269-1272) | ○ |
| C-18 | Selector は metav1.FormatLabelSelector | E-03 (行1271) | ○ |
| C-19 | printJobList は Items を順に委譲 | E-04 | ○ |
| C-20 | Duration は duration.HumanDuration で整形 | E-03 (行1247, 1249) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: Completions 表示の 3 パターン分岐はコードに忠実で低リスク
- 0: Status 判定の優先順位はコードの if/else if 順序に完全一致

## 6) レビュアーチェックリスト（最小）
- [ ] jobColumnDefinitions の 8 カラムが設計書と一致しているか確認
- [ ] Status 判定の優先順位（Complete > Failed > Terminating > Suspended > FailureTarget > SuccessCriteriaMet > Running）がコードと一致しているか確認
- [ ] Completions 表示の 3 パターン（Completions 設定あり / Parallelism > 1 / それ以外）が正しいか確認
- [ ] Duration の 3 パターン（未開始 / 実行中 / 完了）が正しいか確認
