---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：71-Nodeリソース使用状況

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数（数十〜数千Node）**：根拠不足（実運用環境依存の推定値）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` - TopNodeOptions構造体、RunTopNode関数
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/top/top.go` - SupportedMetricsAPIVersionAvailable関数
- E-03: `staging/src/k8s.io/kubectl/pkg/metricsutil/metrics_printer.go` - TopCmdPrinter、PrintNodeMetrics、printSingleResourceUsage
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` 行58-69 - コマンド説明とExamples

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドは `kubectl top node` で実行される | E-04（行81: Use "node [NAME \| -l label]"） | ○ |
| C-02 | TopNodeOptionsにResourceName, Selector, SortBy等のフィールドがある | E-01（行41-56） | ○ |
| C-03 | ヘッダー列はNAME, CPU(cores), CPU(%), MEMORY(bytes), MEMORY(%) | E-03（行60） | ○ |
| C-04 | --show-swapオプションでSWAP列が追加される | E-03（行65-69）、E-01（行99） | ○ |
| C-05 | --sort-byはcpuまたはmemoryのみ受け付ける | E-01（行137-141） | ○ |
| C-06 | NAMEと-lセレクタは同時指定不可 | E-01（行142-144） | ○ |
| C-07 | Metrics APIがv1beta1を使用する | E-02（行36-38）、E-01（行218-219） | ○ |
| C-08 | メトリクス0件時は "metrics not available yet" エラー | E-01（行174-176） | ○ |
| C-09 | --show-capacity時はCapacityを使用、デフォルトはAllocatable | E-01（行198-201） | ○ |
| C-10 | CPU使用率はMilliValue()同士の割合で計算 | E-03（行236-239） | ○ |
| C-11 | CPUはミリコア(m)、メモリはMiB単位で表示 | E-03（行244-252） | ○ |
| C-12 | UseProtocolBuffersがデフォルトtrue | E-01（行76） | ○ |
| C-13 | メトリクス未取得Nodeは`<unknown>`で表示 | E-03（行210-218） | ○ |
| C-14 | SwapCapacityがnil時はRegisterMissingResourceで記録 | E-01（行204-209）、E-03（行148-153） | ○ |
| C-15 | PrintNodeMetricsでソート後にヘッダー・明細出力 | E-03（行74-103） | ○ |
| C-16 | Metrics API not available エラーが発生する | E-01（行165-167） | ○ |
| C-17 | tabwriterによるタブ区切り出力 | E-03（行78: printers.GetNewTabWriter） | ○ |
| C-18 | 想定データ件数は数十〜数千Node | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: 想定データ件数について、コードには上限値の定義がなく、実運用環境に依存する推定値である
  - 候補：Kubernetes公式ドキュメントのクラスタサイズ制限 / 実運用環境のベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックと出力仕様はすべてソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ヘッダー列名がソースコード（metrics_printer.go行60）と一致しているか確認
- [ ] CPU/メモリの表示単位（m/Mi）がソースコード（metrics_printer.go行244-252）と一致しているか確認
- [ ] パーセンテージ計算の端数処理（int64キャスト=切り捨て）がソースコード（metrics_printer.go行239）と一致しているか確認
