---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：72-Podリソース使用状況

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数（数十〜数万Pod）**：根拠不足（実運用環境依存の推定値）

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_pod.go` - TopPodOptions構造体、RunTopPod関数、verifyEmptyMetrics関数
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/top/top.go` - SupportedMetricsAPIVersionAvailable関数
- E-03: `staging/src/k8s.io/kubectl/pkg/metricsutil/metrics_printer.go` - TopCmdPrinter、PrintPodMetrics、getPodMetrics、printPodResourcesSum

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドは `kubectl top pod` で実行される | E-01（行100: Use "pod [NAME \| -l label]"） | ○ |
| C-02 | TopPodOptionsにNamespace, AllNamespaces, PrintContainers, Sum等がある | E-01（行45-64） | ○ |
| C-03 | podColumnsはNAME, CPU(cores), MEMORY(bytes) | E-03（行61） | ○ |
| C-04 | --containersオプションでコンテナ単位表示 | E-01（行116）、E-03（行128-131） | ○ |
| C-05 | --all-namespacesで全Namespace横断表示 | E-01（行117）、E-03（行114-116） | ○ |
| C-06 | --sumオプションで合計行出力 | E-01（行120）、E-03（行137-143） | ○ |
| C-07 | --sort-byはcpuまたはmemoryのみ受け付ける | E-01（行162-166） | ○ |
| C-08 | NAMEとセレクタは同時指定不可 | E-01（行167-169） | ○ |
| C-09 | Pod単位メトリクスはコンテナUsageを合算 | E-03（行188-202: getPodMetrics関数） | ○ |
| C-10 | メトリクス0件時にverifyEmptyMetricsで診断 | E-01（行206-220） | ○ |
| C-11 | Pod作成から2分（metricsCreationDelay）で判定 | E-01（行66: metricsCreationDelay = 2 * time.Minute） | ○ |
| C-12 | Pod作成2分以上でメトリクスなしは個別エラーメッセージ | E-01（行282-285） | ○ |
| C-13 | --show-swapオプションでSWAP列追加 | E-01（行121）、E-03（行66-69） | ○ |
| C-14 | UseProtocolBuffersがデフォルトtrue | E-01（行95） | ○ |
| C-15 | CPUはミリコア(m)、メモリはMiB単位で表示 | E-03（行244-252） | ○ |
| C-16 | --field-selectorによるフィールドセレクタ指定可能 | E-01（行114）、E-01（行182-188） | ○ |
| C-17 | Metrics API v1beta1を使用 | E-02（行36-38）、E-01（行231） | ○ |
| C-18 | 合計行は区切り線（________）付き | E-03（行264-265） | ○ |
| C-19 | AllNamespaces時はNamespaceAllを使用 | E-01（行227-229） | ○ |
| C-20 | 想定データ件数は数十〜数万Pod | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: 想定データ件数について、コードには上限値の定義がなく、実運用環境に依存する推定値である
  - 候補：Kubernetes公式ドキュメントのクラスタサイズ制限（最大150,000 Pod/クラスタ）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックと出力仕様はすべてソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ヘッダー列名がソースコード（metrics_printer.go行61）と一致しているか確認
- [ ] getPodMetrics関数（metrics_printer.go行188-202）のコンテナ合算ロジックが正しく記載されているか確認
- [ ] verifyEmptyMetrics/checkPodAgeの診断ロジック（top_pod.go行252-290）が正しく記載されているか確認
- [ ] --sumオプション時の合計行出力がprintPodResourcesSum（metrics_printer.go行260-276）と一致しているか確認
