---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-CronJob一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. 優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/printers/internalversion/printers.go` 行 184-195（cronJobColumnDefinitions）
- E-02: `pkg/printers/internalversion/printers.go` 行 196-197（TableHandler 登録）
- E-03: `pkg/printers/internalversion/printers.go` 行 1288-1309（printCronJob 関数）
- E-04: `pkg/printers/internalversion/printers.go` 行 1311-1321（printCronJobList 関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronJob のカラムは 7 通常 + 3 wide の計 10 列 | E-01 | ○ |
| C-02 | Schedule は Spec.Schedule から取得 | E-03 (行1303) | ○ |
| C-03 | Timezone は Spec.TimeZone、nil なら "<none>" | E-03 (行1298-1301) | ○ |
| C-04 | Suspend は printBoolPtr(Spec.Suspend) | E-03 (行1303) | ○ |
| C-05 | Active は int64(len(Status.Active)) | E-03 (行1303) | ○ |
| C-06 | Last Schedule は Status.LastScheduleTime、nil なら "<none>" | E-03 (行1293-1296) | ○ |
| C-07 | Age は translateTimestampSince(CreationTimestamp) | E-03 (行1303) | ○ |
| C-08 | Wide 時のコンテナは JobTemplate.Spec.Template.Spec.Containers から取得 | E-03 (行1305) | ○ |
| C-09 | Wide 時のセレクタは JobTemplate.Spec.Selector から取得 | E-03 (行1306) | ○ |
| C-10 | Name カラムは Format: "name" | E-01 (行185) | ○ |
| C-11 | Schedule カラムの Description は CronJobSpec の schedule | E-01 (行186) | ○ |
| C-12 | Timezone カラムの Description は CronJobSpec の timeZone | E-01 (行187) | ○ |
| C-13 | Suspend カラムの Type は "boolean" | E-01 (行188) | ○ |
| C-14 | Active カラムの Type は "integer" | E-01 (行189) | ○ |
| C-15 | printCronJobList は Items を順に委譲 | E-04 | ○ |
| C-16 | printCronJob と printCronJobList が登録 | E-02 | ○ |
| C-17 | Containers, Images, Selector の Priority は 1 | E-01 (行192-194) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: CronJob の print 関数は nil チェックが中心で低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] cronJobColumnDefinitions の 10 カラムが設計書と一致しているか確認
- [ ] TimeZone / LastScheduleTime の nil 時のデフォルト値 "<none>" が正しいか確認
- [ ] Active が len(Status.Active) で計算されている点が正しいか確認
- [ ] Wide 出力のデータソースパス（JobTemplate.Spec.Template.Spec.Containers）が正しいか確認
